package com.atlassian.adf.model.ex.node;

/**
 * Reports a problem with the {@code content} section for a node.
 */
public abstract class ContentException extends NodeException {
    private static final long serialVersionUID = 1L;

    ContentException(String message) {
        super(message);
    }

    /**
     * Reports that the {@code content} field was not provided on a node that requires its presence.
     * Some node types require the {@code content} field to be specified even though they permit it
     * to be left empty. This may be silly, but we're just following the spec, here...
     */
    public static class FieldRequired extends ContentException {
        private static final long serialVersionUID = 1L;

        public FieldRequired() {
            super("The content field is required (even if it is left empty)");
        }
    }

    /**
     * Reports that the {@code content} fields was not provided or was left empty on a node that
     * requires at least one content item to be valid. For example, a {@code listItem} node must
     * contain at least one content item within it.
     */
    public static class ContentRequired extends ContentException {
        private static final long serialVersionUID = 1L;

        public ContentRequired() {
            super("At least one content item is required");
        }
    }
}
