package com.atlassian.adf.model.ex.mark;

import static java.util.Objects.requireNonNull;

/**
 * Reports a problem with a {@code textColor} mark.
 */
public abstract class TextColorException extends MarkException {
    private static final long serialVersionUID = 1L;

    TextColorException(String message) {
        super(message);
    }

    /**
     * Indicates that the requested {@code color} attribute for a {@code textColor} mark is not supported.
     * The color can only be given as a 6-digit hex value with a leading hash mark, such as {@code #03cff8}.
     */
    public static class InvalidColor extends TextColorException {
        private static final long serialVersionUID = 1L;

        private final String color;

        public InvalidColor(String color) {
            super("textColor: invalid 'color' value: '" + color + '\'');
            this.color = requireNonNull(color, "color");
        }

        public String color() {
            return color;
        }
    }
}
