package com.atlassian.adf.model.ex.mark;

/**
 * Reports a problem with a {@code dataConsumer} mark.
 */
public abstract class DataConsumerException extends MarkException {
    private static final long serialVersionUID = 1L;

    DataConsumerException(String message) {
        super(message);
    }

    /**
     * Reports a problem with the {@code sources} attribute of a {@code dataConsumer} mark.
     */
    public static abstract class SourceException extends DataConsumerException {
        private static final long serialVersionUID = 1L;

        public SourceException(String message) {
            super(message);
        }
    }

    /**
     * Reports that the same source was listed multiple times for the same {@code dataConsumer}.
     * The source values should be distinct.
     */
    public static class DuplicateSource extends SourceException {
        private static final long serialVersionUID = 1L;

        private final String source;

        public DuplicateSource(String source) {
            super("Duplicate source: '" + source + '\'');
            this.source = source;
        }

        public String source() {
            return source;
        }
    }

    /**
     * Reports that no sources were provided for the {@code dataConsumer}.
     * At least one source is required.
     */
    public static class NoSources extends SourceException {
        private static final long serialVersionUID = 1L;

        public NoSources() {
            super("A data consumer must have at least one source");
        }
    }
}
