package com.atlassian.adf.model.ex.mark;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.mark.Border;

/**
 * Reports a problem with a {@code border} mark.
 */
public class BorderException extends AdfException {
    private static final long serialVersionUID = 1L;

    BorderException(String message) {
        super(message);
    }

    /**
     * Reports that a {@code border} mark specified a {@code size} that is out of range.
     * Only the values from {@value Border#MINIMUM_SIZE} to {@value Border#MAXIMUM_SIZE}
     * (inclusive) are supported.
     */
    public static class InvalidSize extends BorderException {
        private static final long serialVersionUID = 1L;

        private final int size;

        public InvalidSize(int size) {
            super("The border size must be within the range [" + Border.MINIMUM_SIZE + ", "
                    + Border.MAXIMUM_SIZE + "]: " + size);
            this.size = size;
        }

        public int size() {
            return size;
        }
    }

    /**
     * Reports that a {@code border} mark specified am invalid value for its {@code color}.
     * The value must be the hash mark {@code #} followed by exactly {@code 6} or {@code 8}
     * hexadecimal digits (both uppercase and lowercase are accepted).
     */
    public static class InvalidColor extends BorderException {
        private static final long serialVersionUID = 1L;

        private final String color;

        public InvalidColor(String color) {
            super("Invalid color value: '" + color + '\'');
            this.color = color;
        }

        public String color() {
            return color;
        }
    }
}
