/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class Panel
extends AbstractContentNode<Panel, PanelContent>
implements DocContent,
LayoutColumnContent,
NonNestableBlockContent,
TableCellContent {
    static Factory<Panel> FACTORY = new Factory<Panel>("panel", Panel.class, Panel::parse);
    private PanelType panelType;

    private Panel(PanelType panelType) {
        this.panelType = panelType;
    }

    @Override
    protected void validateContentNodeForAppend(PanelContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof Heading) {
            ((Heading)node).disableMarks(this);
        }
    }

    public static Partial.NeedsPanelType panel() {
        return new Partial.NeedsPanelType();
    }

    public static Panel info(String content) {
        return (Panel)Panel.panel().info().content(Paragraph.p(content));
    }

    public static Panel info(String ... content) {
        return (Panel)Panel.panel().info().content(Paragraph.p(content));
    }

    public static Panel info(PanelContent content) {
        return (Panel)Panel.panel().info().content(content);
    }

    public static Panel info(PanelContent ... content) {
        return (Panel)Panel.panel().info().content(content);
    }

    public static Panel info(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().info().content(content);
    }

    public static Panel info(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().info().content(content);
    }

    public static Panel tip(String content) {
        return (Panel)Panel.panel().tip().content(Paragraph.p(content));
    }

    public static Panel tip(String ... content) {
        return (Panel)Panel.panel().tip().content(Paragraph.p(content));
    }

    public static Panel tip(PanelContent content) {
        return (Panel)Panel.panel().tip().content(content);
    }

    public static Panel tip(PanelContent ... content) {
        return (Panel)Panel.panel().tip().content(content);
    }

    public static Panel tip(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().tip().content(content);
    }

    public static Panel tip(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().tip().content(content);
    }

    public static Panel note(String content) {
        return (Panel)Panel.panel().note().content(Paragraph.p(content));
    }

    public static Panel note(String ... content) {
        return (Panel)Panel.panel().note().content(Paragraph.p(content));
    }

    public static Panel note(PanelContent content) {
        return (Panel)Panel.panel().note().content(content);
    }

    public static Panel note(PanelContent ... content) {
        return (Panel)Panel.panel().note().content(content);
    }

    public static Panel note(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().note().content(content);
    }

    public static Panel note(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().note().content(content);
    }

    public static Panel warning(String content) {
        return (Panel)Panel.panel().warning().content(Paragraph.p(content));
    }

    public static Panel warning(String ... content) {
        return (Panel)Panel.panel().warning().content(Paragraph.p(content));
    }

    public static Panel warning(PanelContent content) {
        return (Panel)Panel.panel().warning().content(content);
    }

    public static Panel warning(PanelContent ... content) {
        return (Panel)Panel.panel().warning().content(content);
    }

    public static Panel warning(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().warning().content(content);
    }

    public static Panel warning(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().warning().content(content);
    }

    public static Panel success(String content) {
        return (Panel)Panel.panel().success().content(Paragraph.p(content));
    }

    public static Panel success(String ... content) {
        return (Panel)Panel.panel().success().content(Paragraph.p(content));
    }

    public static Panel success(PanelContent content) {
        return (Panel)Panel.panel().success().content(content);
    }

    public static Panel success(PanelContent ... content) {
        return (Panel)Panel.panel().success().content(content);
    }

    public static Panel success(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().success().content(content);
    }

    public static Panel success(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().success().content(content);
    }

    public static Panel error(String content) {
        return (Panel)Panel.panel().error().content(Paragraph.p(content));
    }

    public static Panel error(String ... content) {
        return (Panel)Panel.panel().error().content(Paragraph.p(content));
    }

    public static Panel error(PanelContent content) {
        return (Panel)Panel.panel().error().content(content);
    }

    public static Panel error(PanelContent ... content) {
        return (Panel)Panel.panel().error().content(content);
    }

    public static Panel error(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().error().content(content);
    }

    public static Panel error(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().error().content(content);
    }

    public static Panel custom(String content) {
        return (Panel)Panel.panel().custom().content(Paragraph.p(content));
    }

    public static Panel custom(String ... content) {
        return (Panel)Panel.panel().custom().content(Paragraph.p(content));
    }

    public static Panel custom(PanelContent content) {
        return (Panel)Panel.panel().custom().content(content);
    }

    public static Panel custom(PanelContent ... content) {
        return (Panel)Panel.panel().custom().content(content);
    }

    public static Panel custom(Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel().custom().content(content);
    }

    public static Panel custom(Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel().custom().content(content);
    }

    public static Panel panel(String panelType) {
        Objects.requireNonNull(panelType, "panelType");
        return new Panel(PanelType.PARSER.parse(panelType));
    }

    public static Panel panel(PanelType panelType) {
        Objects.requireNonNull(panelType, "panelType");
        return new Panel(panelType);
    }

    public static Panel panel(String panelType, PanelContent content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(String panelType, PanelContent ... content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(String panelType, Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(String panelType, Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(PanelType panelType, PanelContent content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(PanelType panelType, PanelContent ... content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(PanelType panelType, Iterable<? extends PanelContent> content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    public static Panel panel(PanelType panelType, Stream<? extends PanelContent> content) {
        return (Panel)Panel.panel(panelType).content(content);
    }

    @Override
    public Panel content(String content) {
        return (Panel)this.content(Paragraph.p(content));
    }

    @Override
    public Panel content(String ... content) {
        return (Panel)this.content(Paragraph.p(content));
    }

    public PanelType panelType() {
        return this.panelType;
    }

    public Panel panelType(String panelType) {
        return this.panelType(PanelType.PARSER.parse(panelType));
    }

    public Panel panelType(PanelType panelType) {
        this.panelType = Objects.requireNonNull(panelType, "panelType");
        return this;
    }

    public Panel info() {
        return this.panelType(PanelType.INFO);
    }

    public Panel note() {
        return this.panelType(PanelType.NOTE);
    }

    public Panel tip() {
        return this.panelType(PanelType.TIP);
    }

    public Panel warning() {
        return this.panelType(PanelType.WARNING);
    }

    public Panel error() {
        return this.panelType(PanelType.ERROR);
    }

    public Panel success() {
        return this.panelType(PanelType.SUCCESS);
    }

    public Panel custom() {
        return this.panelType(PanelType.CUSTOM);
    }

    @Override
    public Panel copy() {
        return Panel.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "panel";
    }

    @Override
    protected int contentNodeHashCode() {
        return this.panelType.hashCode();
    }

    @Override
    protected boolean contentNodeEquals(Panel other) {
        return this.panelType.equals((Object)other.panelType);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("panelType", (Object)this.panelType);
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
        for (PanelContent node : this.content) {
            if (node instanceof Paragraph) {
                ((Paragraph)node).disableMarks(this);
                continue;
            }
            if (!(node instanceof Heading)) continue;
            ((Heading)node).disableMarks(this);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).add("attrs", FieldMap.map().add("panelType", this.panelType.panelType()));
    }

    private static Panel parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "panel");
        return (Panel)Panel.panel(ParserSupport.getAttrOrThrow(map, "panelType", String.class)).parseRequiredContent(map, PanelContent.class);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextContentJoinedWith('\n', sb);
    }

    public static interface Partial {

        public static class NeedsPanelType {
            public Panel panelType(String panelType) {
                return this.panelType(PanelType.PARSER.parse(panelType));
            }

            public Panel panelType(PanelType panelType) {
                return new Panel(panelType);
            }

            public Panel info() {
                return new Panel(PanelType.INFO);
            }

            public Panel note() {
                return new Panel(PanelType.NOTE);
            }

            public Panel tip() {
                return new Panel(PanelType.TIP);
            }

            public Panel warning() {
                return new Panel(PanelType.WARNING);
            }

            public Panel error() {
                return new Panel(PanelType.ERROR);
            }

            public Panel success() {
                return new Panel(PanelType.SUCCESS);
            }

            public Panel custom() {
                return new Panel(PanelType.CUSTOM);
            }
        }
    }

    public static enum PanelType {
        INFO("info"),
        NOTE("note"),
        TIP("tip"),
        WARNING("warning"),
        ERROR("error"),
        SUCCESS("success"),
        CUSTOM("custom");

        static final EnumParser<PanelType> PARSER;
        private final String panelType;

        private PanelType(String panelType) {
            this.panelType = panelType;
        }

        public String panelType() {
            return this.panelType;
        }

        static {
            PARSER = new EnumParser<PanelType>(PanelType.class, PanelType::panelType);
        }
    }
}

