/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.type.MediaSingleMark;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Caption;
import com.atlassian.adf.model.node.Media;
import com.atlassian.adf.model.node.NodeParserSupport;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class MediaSingle
extends AbstractMarkedNode<MediaSingle, MediaSingleMark>
implements DocContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
TableCellContent {
    static Factory<MediaSingle> FACTORY = new Factory<MediaSingle>("mediaSingle", MediaSingle.class, MediaSingle::parse);
    private Layout layout;
    private Media media;
    @Nullable
    private Number width;
    @Nullable
    private Caption caption;

    private MediaSingle(Layout layout, Media media) {
        this.layout = Objects.requireNonNull(layout, "layout");
        this.media = Objects.requireNonNull(media, "media");
    }

    public static Partial.NeedsMedia mediaSingle() {
        return new Partial.NeedsMedia(Layout.CENTER);
    }

    public static Partial.NeedsMedia mediaSingle(Layout layout) {
        return new Partial.NeedsMedia(layout);
    }

    public static MediaSingle mediaSingle(String layout, Media media) {
        return new MediaSingle(Layout.PARSER.parse(layout), media);
    }

    public static MediaSingle mediaSingle(Layout layout, Media media) {
        return new MediaSingle(layout, media);
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public MediaSingle width(@Nullable Number width) {
        this.width = MediaSingle.validateWidth(width);
        return this;
    }

    public Media media() {
        return this.media;
    }

    public MediaSingle media(Media media) {
        this.media = Objects.requireNonNull(media, "media");
        return this;
    }

    public Optional<Caption> caption() {
        return Optional.ofNullable(this.caption);
    }

    public MediaSingle caption(Caption caption) {
        this.caption = caption;
        return this;
    }

    public MediaSingle caption(String captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(String ... captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(CaptionContent captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(CaptionContent ... captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(Iterable<? extends CaptionContent> captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(Stream<? extends CaptionContent> captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public Layout layout() {
        return this.layout;
    }

    public MediaSingle layout(String layout) {
        this.layout = Layout.PARSER.parse(layout);
        return this;
    }

    public MediaSingle layout(Layout layout) {
        this.layout = Objects.requireNonNull(layout, "layout");
        return this;
    }

    public MediaSingle wrapLeft() {
        return this.layout(Layout.WRAP_LEFT);
    }

    public MediaSingle center() {
        return this.layout(Layout.CENTER);
    }

    public MediaSingle wrapRight() {
        return this.layout(Layout.WRAP_RIGHT);
    }

    public MediaSingle wide() {
        return this.layout(Layout.WIDE);
    }

    public MediaSingle fullWidth() {
        return this.layout(Layout.FULL_WIDTH);
    }

    public MediaSingle alignStart() {
        return this.layout(Layout.ALIGN_START);
    }

    public MediaSingle alignEnd() {
        return this.layout(Layout.ALIGN_END);
    }

    @Override
    public MediaSingle copy() {
        return MediaSingle.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mediaSingle";
    }

    @Override
    protected boolean markedNodeEquals(MediaSingle other) {
        return this.layout == other.layout && this.media.equals(other.media) && MediaSingle.numberEq(this.width, other.width) && Objects.equals(this.caption, other.caption);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.media, MediaSingle.numberHash(this.width), this.caption});
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("layout", (Object)this.layout);
        buf.appendField("width", this.width);
        buf.appendField("media", this.media);
        buf.appendField("caption", this.caption);
    }

    @Override
    public Class<MediaSingleMark> markClass() {
        return MediaSingleMark.class;
    }

    @Override
    public MediaSingle mark(MediaSingleMark mark) {
        this.marks.add(mark);
        return this;
    }

    public MediaSingle link(@Nullable Link link) {
        this.marks.remove("link");
        if (link != null) {
            this.marks.add(link);
        }
        return this;
    }

    public MediaSingle link(@Nullable String href) {
        return this.link(href != null ? Link.link(href) : null);
    }

    public Optional<Link> link() {
        return this.marks.get("link").map(Link.class::cast);
    }

    @Override
    public Map<String, ?> toMap() {
        ArrayList content = new ArrayList(2);
        content.add(this.media.toMap());
        Optional.ofNullable(this.caption).map(Element::toMap).ifPresent(content::add);
        return this.mapWithType().add("content", content).add("attrs", FieldMap.map().addMapped("layout", this.layout, Layout::layout).addIfPresent("width", this.width)).let(this.marks::addToMap);
    }

    private static MediaSingle parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mediaSingle");
        Layout layout = Layout.PARSER.parse(ParserSupport.getAttrOrThrow(map, "layout", String.class));
        List<Map<String, ?>> contentMaps = AbstractContentNode.getRequiredContentMaps(map);
        Media media = AdfException.frame("[0]", () -> NodeParserSupport.getNodeOfType(Media.class, (Map)contentMaps.get(0), "mediaSingle"));
        MediaSingle mediaSingle = new MediaSingle(layout, media);
        ParserSupport.getAttr(map, "width", Number.class).ifPresent(mediaSingle::width);
        mediaSingle.parseMarks(map);
        int count = contentMaps.size();
        if (count > 1) {
            AdfException.frame("[1]", () -> mediaSingle.caption(NodeParserSupport.getNodeOfType(Caption.class, (Map)contentMaps.get(1), mediaSingle)));
            if (count > 2) {
                throw new MediaException.TooManyContentItems(count).backtrace("[2]");
            }
        }
        return mediaSingle;
    }

    @Nullable
    private static Number validateWidth(@Nullable Number newValue) {
        double widthDouble;
        if (newValue != null && ((widthDouble = newValue.doubleValue()) < 0.0 || widthDouble > 100.0)) {
            throw new MediaException.WidthMustBeValidPercentage(newValue);
        }
        return newValue;
    }

    public static enum Layout {
        WRAP_LEFT("wrap-left"),
        CENTER("center"),
        WRAP_RIGHT("wrap-right"),
        WIDE("wide"),
        FULL_WIDTH("full-width"),
        ALIGN_START("align-start"),
        ALIGN_END("align-end");

        static final EnumParser<Layout> PARSER;
        private final String layout;

        private Layout(String layout) {
            this.layout = layout;
        }

        public String layout() {
            return this.layout;
        }

        static {
            PARSER = new EnumParser<Layout>(Layout.class, Layout::layout);
        }
    }

    public static interface Partial {

        public static class NeedsMedia {
            private Layout layout;
            @Nullable
            private Number width;

            NeedsMedia(Layout layout) {
                this.layout = Objects.requireNonNull(layout, "layout");
            }

            public NeedsMedia layout(String layout) {
                return this.layout(Layout.PARSER.parse(layout));
            }

            public NeedsMedia layout(Layout layout) {
                this.layout = Objects.requireNonNull(layout, "layout");
                return this;
            }

            public NeedsMedia wrapLeft() {
                return this.layout(Layout.WRAP_LEFT);
            }

            public NeedsMedia center() {
                return this.layout(Layout.CENTER);
            }

            public NeedsMedia wrapRight() {
                return this.layout(Layout.WRAP_RIGHT);
            }

            public NeedsMedia wide() {
                return this.layout(Layout.WIDE);
            }

            public NeedsMedia fullWidth() {
                return this.layout(Layout.FULL_WIDTH);
            }

            public NeedsMedia alignStart() {
                return this.layout(Layout.ALIGN_START);
            }

            public NeedsMedia alignEnd() {
                return this.layout(Layout.ALIGN_END);
            }

            @CheckReturnValue
            public NeedsMedia width(@Nullable Number width) {
                this.width = MediaSingle.validateWidth(width);
                return this;
            }

            @CheckReturnValue
            public MediaSingle media(Media media) {
                return new MediaSingle(this.layout, media).width(this.width);
            }
        }
    }
}

