/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class Emoji
extends AbstractNode<Emoji>
implements CaptionContent,
InlineContent {
    static Factory<Emoji> FACTORY = new Factory<Emoji>("emoji", Emoji.class, Emoji::parse);
    private String shortName;
    @Nullable
    private String id;
    @Nullable
    private String text;

    private Emoji(String shortName) {
        this.shortName = Emoji.validateShortName(shortName);
    }

    public static Partial.NeedsShortName emoji() {
        return new Partial.NeedsShortName();
    }

    public static Emoji emoji(String shortName) {
        return new Emoji(shortName);
    }

    public Emoji shortName(String shortName) {
        this.shortName = Emoji.validateShortName(shortName);
        return this;
    }

    public String shortName() {
        return this.shortName;
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public Emoji id(String id) {
        this.id = id;
        return this;
    }

    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    public Emoji text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Emoji copy() {
        return Emoji.parse(this.toMap());
    }

    @Override
    protected boolean nodeEquals(Emoji other) {
        return this.shortName.equals(other.shortName) && Objects.equals(this.id, other.id) && Objects.equals(this.text, other.text);
    }

    @Override
    protected int nodeHashCode() {
        return Objects.hash(this.shortName, this.id, this.text);
    }

    @Override
    protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendTextField(this.text);
        buf.appendField("shortName", this.shortName);
        buf.appendField("id", this.id);
    }

    @Override
    public String elementType() {
        return "emoji";
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("shortName", this.shortName).addIfPresent("id", this.id).addIfPresent("text", this.text));
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.text;
        sb.append(text != null ? text : this.shortName);
    }

    private static Emoji parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "emoji");
        Emoji emoji = Emoji.emoji(ParserSupport.getAttrOrThrow(map, "shortName", String.class));
        ParserSupport.getAttr(map, "id", String.class).ifPresent(emoji::id);
        ParserSupport.getAttr(map, "text", String.class).ifPresent(emoji::text);
        return emoji;
    }

    private static String validateShortName(String shortName) {
        Objects.requireNonNull(shortName, "shortName");
        return Element.nonEmpty(shortName, "shortName");
    }

    public static interface Standard {
        public static Emoji slightSmile() {
            return Emoji.emoji(":slight_smile:").id("1f642").text("\ud83d\ude42");
        }

        public static Emoji disappointed() {
            return Emoji.emoji(":disappointed:").id("1f61e").text("\ud83d\ude1e");
        }

        public static Emoji stuckOutTongue() {
            return Emoji.emoji(":stuck_out_tongue:").id("1f61b").text("\ud83d\ude1b");
        }

        public static Emoji smiley() {
            return Emoji.emoji(":smiley:").id("1f603").text("\ud83d\ude03");
        }

        public static Emoji wink() {
            return Emoji.emoji(":wink:").id("1f609").text("\ud83d\ude09");
        }

        public static Emoji thumbsUp() {
            return Emoji.emoji(":thumbsup:").id("1f44d").text("\ud83d\udc4d");
        }

        public static Emoji thumbsDown() {
            return Emoji.emoji(":thumbsdown:").id("1f44e").text("\ud83d\udc4e");
        }

        public static Emoji info() {
            return Emoji.emoji(":info:").id("atlassian-info").text(":info:");
        }

        public static Emoji checkMark() {
            return Emoji.emoji(":check_mark:").id("atlassian-check_mark").text(":check_mark:");
        }

        public static Emoji crossMark() {
            return Emoji.emoji(":cross_mark:").id("atlassian-cross_mark").text(":cross_mark:");
        }

        public static Emoji warning() {
            return Emoji.emoji(":warning:").id("atlassian-warning").text(":warning:");
        }

        public static Emoji plus() {
            return Emoji.emoji(":plus:").id("atlassian-plus").text(":plus:");
        }

        public static Emoji minus() {
            return Emoji.emoji(":minus:").id("atlassian-minus").text(":minus:");
        }

        public static Emoji question() {
            return Emoji.emoji(":question:").id("atlassian-question_mark").text(":question:");
        }

        public static Emoji lightBulbOn() {
            return Emoji.emoji(":light_bulb_on:").id("atlassian-light_bulb_on").text(":light_bulb_on:");
        }

        public static Emoji lightBulbOff() {
            return Emoji.emoji(":light_bulb_off:").id("atlassian-light_bulb_off").text(":light_bulb_off:");
        }

        public static Emoji yellowStar() {
            return Emoji.emoji(":yellow_star:").id("atlassian-yellow_star").text(":yellow_star:");
        }

        public static Emoji redStar() {
            return Emoji.emoji(":red_star:").id("atlassian-red_star").text(":red_star:");
        }

        public static Emoji greenStar() {
            return Emoji.emoji(":green_star:").id("atlassian-green_star").text(":green_star:");
        }

        public static Emoji blueStar() {
            return Emoji.emoji(":blue_star:").id("atlassian-blue_star").text(":blue_star:");
        }

        public static Emoji flagOn() {
            return Emoji.emoji(":flag_on:").id("atlassian-flag_on").text(":flag_on:");
        }

        public static Emoji flagOff() {
            return Emoji.emoji(":flag_off:").id("atlassian-flag_off").text(":flag_off:");
        }
    }

    public static interface Partial {

        public static class NeedsShortName {
            NeedsShortName() {
            }

            public Emoji shortName(String shortName) {
                return new Emoji(shortName);
            }
        }
    }
}

