/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.TableCellException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.NestedExpand;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.model.node.type.TableCellNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

abstract class AbstractTableCellNode<N extends AbstractTableCellNode<N>>
extends AbstractContentNode<N, TableCellContent>
implements TableCellNode<N> {
    @Nullable
    protected String background;
    @Nullable
    protected Integer colspan;
    @Nullable
    protected int[] colwidth;
    @Nullable
    protected Integer rowspan;

    AbstractTableCellNode() {
    }

    @Override
    public Optional<String> background() {
        return Optional.ofNullable(this.background);
    }

    @Override
    public N background(@Nullable String background) {
        this.background = background;
        return (N)((AbstractTableCellNode)this.self());
    }

    @Override
    public N content(String content) {
        return (N)((AbstractTableCellNode)this.content(Paragraph.p(content)));
    }

    @Override
    public N content(String ... content) {
        return (N)((AbstractTableCellNode)this.content(Paragraph.p(content)));
    }

    @Override
    public Optional<Integer> rowspan() {
        return Optional.ofNullable(this.rowspan);
    }

    @Override
    public N rowspan(@Nullable Integer rowspan) {
        AbstractTableCellNode.checkRowspan(rowspan);
        this.rowspan = rowspan;
        return (N)((AbstractTableCellNode)this.self());
    }

    @Override
    public Optional<Integer> colspan() {
        return Optional.ofNullable(this.colspan);
    }

    @Override
    public Optional<int[]> colwidth() {
        return Optional.ofNullable(this.colwidth).map(rec$ -> (int[])((int[])rec$).clone());
    }

    public N colspan(@Nullable Integer colspan) {
        return (N)this.colspanAndColwidth(colspan, null);
    }

    public N colwidth(int ... colwidth) {
        return (N)(colwidth != null ? this.colspanAndColwidth(colwidth.length, colwidth) : this.colspanAndColwidth(null, null));
    }

    @Override
    public N colspanAndColwidth(@Nullable Integer colspan, @Nullable int[] colwidth) {
        AbstractTableCellNode.checkColspanAndColwidth(colspan, colwidth);
        this.colspan = colspan;
        this.colwidth = colwidth;
        return (N)((AbstractTableCellNode)this.self());
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        FieldMap attrs = FieldMap.map().addIfPresent("background", this.background).addIfPresent("colspan", this.colspan).addMappedIfPresent("colwidth", this.colwidth, cw -> Arrays.stream(cw).boxed().collect(Collectors.toList())).addIfPresent("rowspan", this.rowspan);
        return FieldMap.map("type", this.elementType()).addIf(!attrs.isEmpty(), "attrs", () -> attrs).let(this::addContent);
    }

    private static int checkColspan(@Nullable Integer colspan) {
        if (colspan == null) {
            return 1;
        }
        if (colspan <= 0) {
            throw new TableCellException.ColspanNotPositive(colspan);
        }
        return colspan;
    }

    private static void checkColspanAndColwidth(@Nullable Integer colspan, @Nullable int[] colwidth) {
        int cols = AbstractTableCellNode.checkColspan(colspan);
        if (colwidth == null) {
            return;
        }
        if (colwidth.length != cols) {
            throw new TableCellException.ColwidthDoesNotMatchColspan(colspan, colwidth);
        }
        boolean allZero = true;
        for (int i = 0; i < colwidth.length; ++i) {
            if (colwidth[i] < 0) {
                throw new TableCellException.ColwidthCannotBeNegative(i, colwidth[i]);
            }
            if (colwidth[i] <= 0) continue;
            allZero = false;
        }
        if (allZero) {
            throw new TableCellException.ColwidthMustHaveAtLeastOnePositiveValue();
        }
    }

    protected N parseTableNode(Map<String, ?> map) {
        this.parseRequiredContent(map, TableCellContent.class);
        this.background = ParserSupport.getAttr(map, "background", String.class).orElse(null);
        ParserSupport.getAttrInt(map, "rowspan").ifPresent(n -> this.rowspan((Integer)n));
        Integer colspan = ParserSupport.getAttrInt(map, "colspan").orElse(null);
        int[] colwidth = this.parseColwidth(map);
        if (colspan != null || colwidth != null) {
            this.colspanAndColwidth(colspan, colwidth);
        }
        this.requireNotEmpty();
        return (N)((AbstractTableCellNode)this.self());
    }

    @Nullable
    private int[] parseColwidth(Map<String, ?> map) {
        List list;
        Object attr = ParserSupport.getAttr(map, "colwidth").orElse(null);
        if (attr == null || attr instanceof int[]) {
            return (int[])attr;
        }
        if (attr instanceof Number[]) {
            list = Arrays.stream((Number[])attr).collect(Collectors.toList());
        } else if (attr instanceof List) {
            list = (List)Cast.unsafeCast(attr);
        } else {
            throw new AdfException.ValueTypeMismatch("colwidth", "int[]", attr.getClass().getSimpleName());
        }
        boolean allZero = true;
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int value = ParserSupport.asInt((Number)list.get(i), "colwidth[" + i + "]");
            if (value < 0) {
                throw new TableCellException.ColwidthCannotBeNegative(i, value);
            }
            if (value > 0) {
                allZero = false;
            }
            result[i] = value;
        }
        if (allZero) {
            throw new TableCellException.ColwidthMustHaveAtLeastOnePositiveValue();
        }
        return result;
    }

    @Override
    protected void validateContentNodeForAppend(TableCellContent node) {
        if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        } else if (node instanceof Paragraph) {
            ((Paragraph)node).disableIndentation(this);
        } else if (node instanceof NestedExpand) {
            ((NestedExpand)node).disableMarks(this);
        }
    }

    @Override
    protected final boolean contentNodeEquals(N other) {
        return Objects.equals(this.background, ((AbstractTableCellNode)other).background) && Objects.equals(this.colspan, ((AbstractTableCellNode)other).colspan) && Arrays.equals(this.colwidth, ((AbstractTableCellNode)other).colwidth) && Objects.equals(this.rowspan, ((AbstractTableCellNode)other).rowspan);
    }

    @Override
    protected final int contentNodeHashCode() {
        return Objects.hash(this.background, this.colspan, this.rowspan, Arrays.hashCode(this.colwidth));
    }

    @Override
    protected final void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("background", this.background);
        buf.appendField("colspan", this.colspan);
        buf.appendField("colwidth", this.colwidth);
        buf.appendField("rowspan", this.rowspan);
    }

    private static void checkRowspan(@Nullable Integer rowspan) {
        if (rowspan != null && rowspan <= 0) {
            throw new TableCellException.RowspanNegative(rowspan);
        }
    }

    @Override
    public final void appendPlainText(StringBuilder sb) {
        this.appendPlainTextContentJoinedWith('\n', sb);
    }
}

