/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class AbstractNode<N extends AbstractNode<N>>
implements Node {
    static final int TEXT_BUFFER_SIZE = 8192;
    private static final double EPSILON = 1.0E-7;
    private static final double ONE_OVER_EPSILON = 1.0E7;

    AbstractNode() {
    }

    protected FieldMap mapWithType() {
        return FieldMap.map("type", this.elementType());
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    public final int hashCode() {
        return this.getClass().hashCode() * 31 + this.nodeHashCode();
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractNode other = (AbstractNode)Cast.unsafeCast(obj);
        return this.nodeEquals(other);
    }

    public final String toString() {
        ToStringHelper buf = new ToStringHelper();
        buf.appendNode(this);
        return buf.toString();
    }

    @Override
    public final String toPlainText() {
        StringBuilder sb = new StringBuilder(8192);
        this.appendPlainText(sb);
        return sb.toString();
    }

    protected int nodeHashCode() {
        return 0;
    }

    protected boolean nodeEquals(N other) {
        return true;
    }

    protected void appendNodeFields(ToStringHelper buf) {
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        if (this instanceof ContentNode) {
            ContentNode contentNode = (ContentNode)Cast.unsafeCast(this);
            AbstractContentNode.appendPlainTextContent(sb, contentNode);
        } else {
            UnsupportedNode.appendPlainTextForUnsupportedNode(this, sb);
        }
    }

    protected final N self() {
        return (N)this;
    }

    protected static boolean doubleEq(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b) || Math.abs(a - b) <= 1.0E-7;
    }

    protected static boolean numberEq(@Nullable Number a, @Nullable Number b) {
        return a != null ? b != null && AbstractNode.doubleEq(a.doubleValue(), b.doubleValue()) : b == null;
    }

    protected static int doubleHash(double value) {
        return Long.hashCode((long)(value * 1.0E7));
    }

    protected static int numberHash(@Nullable Number value) {
        return value != null ? AbstractNode.doubleHash(value.doubleValue()) : 0;
    }

    static class ToStringHelper {
        private final StringBuilder sb = new StringBuilder(8192);

        ToStringHelper() {
        }

        void appendField(String name, @Nullable Object value) {
            if (value == null) {
                return;
            }
            this.sb.append(name).append('=');
            this.appendValue(value);
            this.comma();
        }

        void appendTextField(@Nullable String text) {
            if (text == null) {
                return;
            }
            this.appendString(text);
            this.comma();
        }

        void appendContentField(List<? extends Node> content) {
            if (content.isEmpty()) {
                return;
            }
            this.sb.append("content=");
            this.appendIterable(content);
            this.comma();
        }

        void appendMarksField(MarkHolder<? extends Mark> marks) {
            if (marks.isEmpty()) {
                return;
            }
            this.sb.append("marks=");
            this.appendIterable(marks.get());
            this.comma();
        }

        private void appendValue(@Nullable Object value) {
            if (value == null) {
                this.sb.append("null");
            } else if (value instanceof String) {
                this.appendString((String)value);
            } else if (value instanceof AbstractNode) {
                this.appendNode((AbstractNode)value);
            } else if (value instanceof Iterable) {
                this.appendIterable((Iterable)value);
            } else if (value instanceof Object[]) {
                this.appendObjectArray((Object[])value);
            } else if (value.getClass().isArray()) {
                this.sb.append(ToStringHelper.primitiveArrayToString(value));
            } else if (value instanceof Map) {
                this.appendMap((Map)value);
            } else {
                this.sb.append(value);
            }
        }

        private void appendString(String value) {
            this.sb.append('\u00ab').append(value).append('\u00bb');
        }

        private void appendNode(AbstractNode<?> node) {
            this.sb.append(node.elementType()).append('[');
            node.appendNodeFields(this);
            int pos = this.sb.length() - 2;
            if (pos > 0 && this.sb.charAt(pos) == ',' && this.sb.charAt(pos + 1) == ' ') {
                this.sb.setLength(pos);
            }
            this.sb.append(']');
        }

        private void appendObjectArray(Object[] value) {
            this.sb.append('[');
            for (Object item : value) {
                this.appendValue(item);
                this.comma();
            }
            this.dropLastComma();
            this.sb.append(']');
        }

        private void appendIterable(Iterable<?> value) {
            this.sb.append('[');
            for (Object item : value) {
                this.appendValue(item);
                this.comma();
            }
            this.dropLastComma();
            this.sb.append(']');
        }

        private void appendMap(Map<?, ?> value) {
            this.sb.append('{');
            value.forEach((k, v) -> {
                this.sb.append(k).append(": ");
                this.appendValue(v);
                this.comma();
            });
            this.dropLastComma();
            this.sb.append('}');
        }

        private void comma() {
            this.sb.append(", ");
        }

        private void dropLastComma() {
            int pos = this.sb.length() - 2;
            if (pos > 0 && this.sb.charAt(pos) == ',' && this.sb.charAt(pos + 1) == ' ') {
                this.sb.setLength(pos);
            }
        }

        public String toString() {
            return this.sb.toString();
        }

        private static String primitiveArrayToString(Object value) {
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            return value.getClass().getSimpleName();
        }
    }
}

