/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.util.Cast;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@ReturnValuesAreNonnullByDefault
public class FieldMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public static FieldMap map() {
        return new FieldMap();
    }

    public static FieldMap map(Map<String, ?> source) {
        return new FieldMap().addAll(source);
    }

    public static FieldMap map(String k1, Object v1) {
        Objects.requireNonNull(k1, "k1");
        Objects.requireNonNull(v1, "v1");
        return FieldMap.map().add(k1, v1);
    }

    public static FieldMap map(String k1, Object v1, String k2, Object v2) {
        FieldMap map = FieldMap.map(k1, v1);
        Objects.requireNonNull(k2, "k2");
        Objects.requireNonNull(v2, "v2");
        return map.add(k2, v2);
    }

    public static FieldMap map(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        FieldMap map = FieldMap.map(k1, v1, k2, v2);
        Objects.requireNonNull(k3, "k3");
        Objects.requireNonNull(v3, "v3");
        return map.add(k3, v3);
    }

    public static FieldMap map(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        FieldMap map = FieldMap.map(k1, v1, k2, v2, k3, v3);
        Objects.requireNonNull(k4, "k4");
        Objects.requireNonNull(v4, "v4");
        return map.add(k4, v4);
    }

    public FieldMap add(String k, Object v) {
        Objects.requireNonNull(k, "k");
        Objects.requireNonNull(v, "v");
        this.putUniqueOrThrow(k, v);
        return this;
    }

    public <T> FieldMap addMapped(String k, T v, Function<T, ?> mapper) {
        Objects.requireNonNull(v, "v");
        Optional.of(v).map(mapper).ifPresent(value -> this.putUniqueOrThrow(k, value));
        return this;
    }

    public FieldMap addAll(Map<String, ?> source) {
        source.forEach(this::add);
        return this;
    }

    public FieldMap addIfPresent(String k, @Nullable Object v) {
        if (v != null) {
            this.putUniqueOrThrow(k, v);
        }
        return this;
    }

    public <T> FieldMap addMappedIfPresent(String k, @Nullable T v, Function<T, ?> mapper) {
        Optional.ofNullable(v).map(mapper).ifPresent(value -> this.putUniqueOrThrow(k, value));
        return this;
    }

    public FieldMap addIf(boolean guard, String k, Supplier<?> vSupplier) {
        return guard ? this.addIfPresent(k, vSupplier.get()) : this;
    }

    private void putUniqueOrThrow(String field, Object value) {
        if (this.putIfAbsent(field, value) != null) {
            throw new AdfException.DuplicateProperty(field);
        }
    }

    public FieldMap let(Consumer<FieldMap> effect) {
        effect.accept(this);
        return this;
    }

    public FieldMap deepCopy() {
        return FieldMap.deepCopy(this);
    }

    public static FieldMap deepCopy(Map<String, ?> value) {
        DeepCopy deepCopy = new DeepCopy(false);
        FieldMap copy = FieldMap.map();
        value.forEach((k, v) -> copy.put(k, deepCopy.copyObj(v)));
        return copy;
    }

    public Map<String, ?> immutableCopy() {
        return FieldMap.immutableCopy(this);
    }

    public static Map<String, ?> immutableCopy(Map<String, ?> map) {
        DeepCopy deepCopy = new DeepCopy(true);
        FieldMap copy = FieldMap.map();
        map.forEach((k, v) -> copy.put(k, deepCopy.copyObj(v)));
        return Collections.unmodifiableMap(copy);
    }

    private static class DeepCopy {
        private final boolean immutable;

        private DeepCopy(boolean immutable) {
            this.immutable = immutable;
        }

        Object copyObj(Object value) {
            if (value instanceof Map) {
                Map orig = (Map)Cast.unsafeCast(value);
                FieldMap copy = FieldMap.map();
                orig.forEach((k, v) -> copy.put(k, this.copyObj(v)));
                return this.immutable ? Collections.unmodifiableMap(copy) : copy;
            }
            if (value instanceof Collection) {
                List orig = (List)Cast.unsafeCast(value);
                ArrayList copy = new ArrayList(orig.size());
                orig.forEach(v -> copy.add(this.copyObj(v)));
                return this.immutable ? List.copyOf(copy) : copy;
            }
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                return value;
            }
            throw new IllegalArgumentException("Cannot deep copy: " + value.getClass().getName());
        }
    }
}

