/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.Element;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@ReturnValuesAreNonnullByDefault
public class Factory<T extends Element> {
    private final String type;
    private final Class<T> typeClass;
    private final Function<Map<String, ?>, ? extends T> parser;

    public Factory(String type, Class<T> typeClass, Function<Map<String, ?>, ? extends T> parser) {
        this.type = Objects.requireNonNull(type, "type");
        this.typeClass = Objects.requireNonNull(typeClass, "typeClass");
        this.parser = Objects.requireNonNull(parser, "parser");
    }

    public static <T extends Element, U extends T> Factory<T> unsupported(Class<T> typeClass, Function<Map<String, ?>, U> parser) {
        return new Factory<T>("", typeClass, parser);
    }

    public String type() {
        return this.type;
    }

    public Class<T> typeClass() {
        return this.typeClass;
    }

    public T parse(Map<String, ?> map) {
        return (T)((Element)this.parser.apply(map));
    }

    @SafeVarargs
    public static <K, T extends Element> Map<K, Factory<? extends T>> extractLookupMap(Function<Factory<? extends T>, K> keyExtractor, Factory<? extends T> ... factories) {
        Objects.requireNonNull(keyExtractor, "keyExtractor");
        HashMap<K, Factory<? extends T>> map = new HashMap<K, Factory<? extends T>>();
        for (Factory<? extends T> factory : factories) {
            K key = Objects.requireNonNull(keyExtractor.apply(factory), "key");
            if (map.put(key, factory) == null) continue;
            throw new IllegalStateException("Duplicate key: " + key);
        }
        return Map.copyOf(map);
    }
}

