/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@ReturnValuesAreNonnullByDefault
public abstract class Colors {
    private static final Pattern REGEX_HEX = Pattern.compile("^#([A-Fa-f0-9]{3}){1,2}$");
    private static final Pattern REGEX_RGBA = Pattern.compile("rgba?\\(");
    private static final Pattern REGEX_RGB_VALUES = Pattern.compile("(0?\\.?\\d{1,3})%?\\b");
    public static final String R50 = "#FFEBE6";
    public static final String R75 = "#FFBDAD";
    public static final String R100 = "#FF8F73";
    public static final String R300 = "#FF5630";
    public static final String R400 = "#DE350B";
    public static final String R500 = "#BF2600";
    public static final String Y50 = "#FFFAE6";
    public static final String Y75 = "#FFF0B3";
    public static final String Y200 = "#FFC400";
    public static final String Y400 = "#FF991F";
    public static final String Y500 = "#FF8B00";
    public static final String G50 = "#E3FCEF";
    public static final String G75 = "#ABF5D1";
    public static final String G200 = "#57D9A3";
    public static final String G300 = "#36B37E";
    public static final String G400 = "#00875A";
    public static final String G500 = "#006644";
    public static final String B50 = "#DEEBFF";
    public static final String B75 = "#B3D4FF";
    public static final String B100 = "#4C9AFF";
    public static final String B400 = "#0052CC";
    public static final String B500 = "#0747A6";
    public static final String N0 = "#FFFFFF";
    public static final String N20 = "#F4F5F7";
    public static final String N30 = "#EBECF0";
    public static final String N40 = "#DFE1E6";
    public static final String N50 = "#C1C7D0";
    public static final String N60 = "#B3BAC5";
    public static final String N80 = "#97A0AF";
    public static final String N90 = "#8993A4";
    public static final String N200 = "#6B778C";
    public static final String N300 = "#5E6C84";
    public static final String N500 = "#42526E";
    public static final String N800 = "#172B4D";
    public static final String P50 = "#EAE6FF";
    public static final String P75 = "#C0B6F2";
    public static final String P100 = "#998DD9";
    public static final String P300 = "#6554C0";
    public static final String P400 = "#5243AA";
    public static final String P500 = "#403294";
    public static final String T50 = "#E6FCFF";
    public static final String T75 = "#B3F5FF";
    public static final String T100 = "#79E2F2";
    public static final String T300 = "#00B8D9";
    public static final String T500 = "#008DA6";

    private Colors() {
    }

    public static Optional<String> normalizeHexColor(@Nullable String color) {
        return Colors.normalizeHexColor(color, null);
    }

    public static Optional<String> normalizeHexColor(@Nullable String color, @Nullable String defaultColor) {
        if (color == null) {
            return Optional.empty();
        }
        if (Colors.isHex((String)(color = ((String)color).trim().toLowerCase(Locale.ROOT)))) {
            if (((String)color).length() == 4) {
                color = "#" + ((String)color).charAt(1) + ((String)color).charAt(1) + ((String)color).charAt(2) + ((String)color).charAt(2) + ((String)color).charAt(3) + ((String)color).charAt(3);
            }
        } else {
            if (Colors.isRgb((String)color)) {
                return Colors.rgbToHex((String)color);
            }
            if ("default".equals(color)) {
                return Optional.empty();
            }
            return Named.toHex((String)color);
        }
        if (Objects.equals(color, defaultColor)) {
            return Optional.empty();
        }
        return Optional.of(color);
    }

    public static Optional<String> hexToRgb(String color) {
        return Colors.isHex(color) ? Colors.decode(color).map(Colors::rgb) : Optional.empty();
    }

    public static Optional<String> hexToRgba(String rawColor, Number alpha) {
        return Colors.normalizeHexColor(rawColor).flatMap(Colors::decode).map(color -> Colors.rgba(color, alpha));
    }

    public static Optional<String> rgbToHex(String value) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        Matcher matcher = REGEX_RGB_VALUES.matcher(value);
        while (matcher.find()) {
            int x = Colors.parseColorFieldValue(matcher.group(1));
            if (x < 0) {
                return Optional.empty();
            }
            matches.add(x);
        }
        if (matches.size() != 3) {
            return Optional.empty();
        }
        return Optional.of(Colors.hex(new Color((Integer)matches.get(0), (Integer)matches.get(1), (Integer)matches.get(2))));
    }

    private static int parseColorFieldValue(String value) {
        try {
            int x = value.indexOf(46) == -1 ? Integer.decode(value).intValue() : Double.valueOf(value).intValue();
            return x >= 0 && x <= 255 ? x : -1;
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public static boolean isRgb(String color) {
        return REGEX_RGBA.matcher(color).matches();
    }

    public static boolean isHex(String color) {
        return REGEX_HEX.matcher(color).matches();
    }

    public static String rgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static String rgba(Color color, Number alpha) {
        return "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + alpha + ")";
    }

    public static String hex(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Optional<Color> decode(String color) {
        try {
            return Optional.of(Color.decode(color));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static enum Named {
        aliceblue(new Color(240, 248, 255)),
        antiquewhite(new Color(250, 235, 215)),
        aqua(new Color(0, 255, 255)),
        aquamarine(new Color(127, 255, 212)),
        azure(new Color(240, 255, 255)),
        beige(new Color(245, 245, 220)),
        bisque(new Color(255, 228, 196)),
        black(new Color(0, 0, 0)),
        blanchedalmond(new Color(255, 235, 205)),
        blue(new Color(0, 0, 255)),
        blueviolet(new Color(138, 43, 226)),
        brown(new Color(165, 42, 42)),
        burlywood(new Color(222, 184, 135)),
        cadetblue(new Color(95, 158, 160)),
        chartreuse(new Color(127, 255, 0)),
        chocolate(new Color(210, 105, 30)),
        coral(new Color(255, 127, 80)),
        cornflowerblue(new Color(100, 149, 237)),
        cornsilk(new Color(255, 248, 220)),
        crimson(new Color(220, 20, 60)),
        cyan(new Color(0, 255, 255)),
        darkblue(new Color(0, 0, 139)),
        darkcyan(new Color(0, 139, 139)),
        darkgoldenrod(new Color(184, 134, 11)),
        darkgray(new Color(169, 169, 169)),
        darkgreen(new Color(0, 100, 0)),
        darkgrey(new Color(169, 169, 169)),
        darkkhaki(new Color(189, 183, 107)),
        darkmagenta(new Color(139, 0, 139)),
        darkolivegreen(new Color(85, 107, 47)),
        darkorange(new Color(255, 140, 0)),
        darkorchid(new Color(153, 50, 204)),
        darkred(new Color(139, 0, 0)),
        darksalmon(new Color(233, 150, 122)),
        darkseagreen(new Color(143, 188, 143)),
        darkslateblue(new Color(72, 61, 139)),
        darkslategray(new Color(47, 79, 79)),
        darkslategrey(new Color(47, 79, 79)),
        darkturquoise(new Color(0, 206, 209)),
        darkviolet(new Color(148, 0, 211)),
        deeppink(new Color(255, 20, 147)),
        deepskyblue(new Color(0, 191, 255)),
        dimgray(new Color(105, 105, 105)),
        dimgrey(new Color(105, 105, 105)),
        dodgerblue(new Color(30, 144, 255)),
        firebrick(new Color(178, 34, 34)),
        floralwhite(new Color(255, 250, 240)),
        forestgreen(new Color(34, 139, 34)),
        fuchsia(new Color(255, 0, 255)),
        gainsboro(new Color(220, 220, 220)),
        ghostwhite(new Color(248, 248, 255)),
        gold(new Color(255, 215, 0)),
        goldenrod(new Color(218, 165, 32)),
        gray(new Color(128, 128, 128)),
        green(new Color(0, 128, 0)),
        greenyellow(new Color(173, 255, 47)),
        grey(new Color(128, 128, 128)),
        honeydew(new Color(240, 255, 240)),
        hotpink(new Color(255, 105, 180)),
        indianred(new Color(205, 92, 92)),
        indigo(new Color(75, 0, 130)),
        ivory(new Color(255, 255, 240)),
        khaki(new Color(240, 230, 140)),
        lavender(new Color(230, 230, 250)),
        lavenderblush(new Color(255, 240, 245)),
        lawngreen(new Color(124, 252, 0)),
        lemonchiffon(new Color(255, 250, 205)),
        lightblue(new Color(173, 216, 230)),
        lightcoral(new Color(240, 128, 128)),
        lightcyan(new Color(224, 255, 255)),
        lightgoldenrodyellow(new Color(250, 250, 210)),
        lightgray(new Color(211, 211, 211)),
        lightgreen(new Color(144, 238, 144)),
        lightgrey(new Color(211, 211, 211)),
        lightpink(new Color(255, 182, 193)),
        lightsalmon(new Color(255, 160, 122)),
        lightseagreen(new Color(32, 178, 170)),
        lightskyblue(new Color(135, 206, 250)),
        lightslategray(new Color(119, 136, 153)),
        lightslategrey(new Color(119, 136, 153)),
        lightsteelblue(new Color(176, 196, 222)),
        lightyellow(new Color(255, 255, 224)),
        lime(new Color(0, 255, 0)),
        limegreen(new Color(50, 205, 50)),
        linen(new Color(250, 240, 230)),
        magenta(new Color(255, 0, 255)),
        maroon(new Color(128, 0, 0)),
        mediumaquamarine(new Color(102, 205, 170)),
        mediumblue(new Color(0, 0, 205)),
        mediumorchid(new Color(186, 85, 211)),
        mediumpurple(new Color(147, 112, 219)),
        mediumseagreen(new Color(60, 179, 113)),
        mediumslateblue(new Color(123, 104, 238)),
        mediumspringgreen(new Color(0, 250, 154)),
        mediumturquoise(new Color(72, 209, 204)),
        mediumvioletred(new Color(199, 21, 133)),
        midnightblue(new Color(25, 25, 112)),
        mintcream(new Color(245, 255, 250)),
        mistyrose(new Color(255, 228, 225)),
        moccasin(new Color(255, 228, 181)),
        navajowhite(new Color(255, 222, 173)),
        navy(new Color(0, 0, 128)),
        oldlace(new Color(253, 245, 230)),
        olive(new Color(128, 128, 0)),
        olivedrab(new Color(107, 142, 35)),
        orange(new Color(255, 165, 0)),
        orangered(new Color(255, 69, 0)),
        orchid(new Color(218, 112, 214)),
        palegoldenrod(new Color(238, 232, 170)),
        palegreen(new Color(152, 251, 152)),
        paleturquoise(new Color(175, 238, 238)),
        palevioletred(new Color(219, 112, 147)),
        papayawhip(new Color(255, 239, 213)),
        peachpuff(new Color(255, 218, 185)),
        peru(new Color(205, 133, 63)),
        pink(new Color(255, 192, 203)),
        plum(new Color(221, 160, 221)),
        powderblue(new Color(176, 224, 230)),
        purple(new Color(128, 0, 128)),
        rebeccapurple(new Color(102, 51, 153)),
        red(new Color(255, 0, 0)),
        rosybrown(new Color(188, 143, 143)),
        royalblue(new Color(65, 105, 225)),
        saddlebrown(new Color(139, 69, 19)),
        salmon(new Color(250, 128, 114)),
        sandybrown(new Color(244, 164, 96)),
        seagreen(new Color(46, 139, 87)),
        seashell(new Color(255, 245, 238)),
        sienna(new Color(160, 82, 45)),
        silver(new Color(192, 192, 192)),
        skyblue(new Color(135, 206, 235)),
        slateblue(new Color(106, 90, 205)),
        slategray(new Color(112, 128, 144)),
        slategrey(new Color(112, 128, 144)),
        snow(new Color(255, 250, 250)),
        springgreen(new Color(0, 255, 127)),
        steelblue(new Color(70, 130, 180)),
        tan(new Color(210, 180, 140)),
        teal(new Color(0, 128, 128)),
        thistle(new Color(216, 191, 216)),
        tomato(new Color(255, 99, 71)),
        turquoise(new Color(64, 224, 208)),
        violet(new Color(238, 130, 238)),
        wheat(new Color(245, 222, 179)),
        white(new Color(255, 255, 255)),
        whitesmoke(new Color(245, 245, 245)),
        yellow(new Color(255, 255, 0)),
        yellowgreen(new Color(154, 205, 50));

        private static final Map<String, Named> LOOKUP;
        private final Color color;

        private static Map<String, Named> initLookup() {
            HashMap<String, Named> map = new HashMap<String, Named>();
            for (Named named : Named.values()) {
                map.put(named.name(), named);
            }
            return Collections.unmodifiableMap(map);
        }

        private Named(Color color) {
            this.color = color;
        }

        public static Optional<Named> lookup(@Nullable String name) {
            if (name == null) {
                return Optional.empty();
            }
            name = name.trim().toLowerCase(Locale.ROOT);
            return Optional.ofNullable(LOOKUP.get(name));
        }

        public static Optional<String> toHex(@Nullable String name) {
            return Named.lookup(name).map(Named::toHex);
        }

        public static Optional<String> toRgb(@Nullable String name) {
            return Named.lookup(name).map(Named::toRgb);
        }

        public Color color() {
            return this.color;
        }

        public String toHex() {
            return Colors.hex(this.color);
        }

        public String toRgb() {
            return Colors.rgb(this.color);
        }

        static {
            LOOKUP = Named.initLookup();
        }
    }
}

