/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.TaskListContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TaskItem
extends AbstractContentNode<TaskItem, InlineContent>
implements TaskListContent {
    static final Factory<TaskItem> FACTORY = new Factory<TaskItem>("taskItem", TaskItem.class, TaskItem::parse);
    private String localId;
    private State state;

    private TaskItem(String localId, State state) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.state = Objects.requireNonNull(state, "state");
    }

    public static Partial.NeedsLocalIdAndState taskItem() {
        return new Partial.NeedsLocalIdAndState();
    }

    public static TaskItem todo(String localId) {
        return new TaskItem(localId, State.TODO);
    }

    public static TaskItem done(String localId) {
        return new TaskItem(localId, State.DONE);
    }

    @Override
    public TaskItem content(String content) {
        return (TaskItem)this.content(Text.text(content));
    }

    @Override
    public TaskItem content(String ... content) {
        return (TaskItem)this.content(Text.text(content));
    }

    public TaskItem localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public String localId() {
        return this.localId;
    }

    public TaskItem state(State state) {
        this.state = Objects.requireNonNull(state, "state");
        return this;
    }

    public State state() {
        return this.state;
    }

    public TaskItem todo() {
        return this.state(State.TODO);
    }

    public TaskItem done() {
        return this.state(State.DONE);
    }

    @Override
    public TaskItem copy() {
        return TaskItem.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "taskItem";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).add("attrs", FieldMap.map().add("localId", this.localId).add("state", this.state.name()));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskItem that = (TaskItem)o;
        return this.localId.equals(that.localId) && this.state.equals((Object)that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.localId, this.state});
    }

    @Override
    public String toString() {
        return "TaskItem{localId='" + this.localId + "', state='" + this.state + "', content=" + this.content + "}";
    }

    public static TaskItem parse(Map<String, ?> map) {
        String localId = (String)ParserSupport.getAttrOrThrow(map, "localId");
        State state = State.PARSER.parse((String)ParserSupport.getAttrOrThrow(map, "state"));
        return (TaskItem)new TaskItem(localId, state).parseOptionalContent(map, InlineContent.class);
    }

    public static enum State {
        TODO,
        DONE;

        static final EnumParser<State> PARSER;

        static {
            PARSER = new EnumParser<State>(State.class, Enum::name);
        }
    }

    public static interface Partial {

        public static class NeedsLocalIdAndState {
            NeedsLocalIdAndState() {
            }

            public NeedsState localId(String localId) {
                return new NeedsState(localId);
            }

            public NeedsLocalId state(String state) {
                return this.state(State.PARSER.parse(state));
            }

            public NeedsLocalId state(State state) {
                return new NeedsLocalId(state);
            }

            public NeedsLocalId todo() {
                return this.state(State.TODO);
            }

            public NeedsLocalId done() {
                return this.state(State.DONE);
            }
        }

        public static class NeedsLocalId {
            private final State state;

            NeedsLocalId(State state) {
                this.state = Objects.requireNonNull(state, "state");
            }

            public TaskItem localId(String localId) {
                return new TaskItem(localId, this.state);
            }
        }

        public static class NeedsState {
            private final String localId;

            NeedsState(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public TaskItem state(String state) {
                Objects.requireNonNull(state, "state");
                return this.state(State.PARSER.parse(state));
            }

            public TaskItem state(State state) {
                Objects.requireNonNull(state, "state");
                return new TaskItem(this.localId, state);
            }

            public TaskItem todo() {
                return this.state(State.TODO);
            }

            public TaskItem done() {
                return this.state(State.DONE);
            }
        }
    }
}

