/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class MediaInline
extends AbstractNode
implements Marked<MediaInline, Link>,
InlineContent {
    static Factory<MediaInline> FACTORY = new Factory<MediaInline>("mediaInline", MediaInline.class, MediaInline::parse);
    private String id;
    private String collection;
    @Nullable
    private MediaType mediaType;
    @Nullable
    private String occurrenceKey;
    @Nullable
    private Number width;
    @Nullable
    private Number height;
    @Nullable
    private String alt;
    @Nullable
    private Link link;
    @Nullable
    private Map<String, ?> data;

    private MediaInline(String id, String collection) {
        this.id = MediaInline.validateId(id);
        this.collection = MediaInline.validateCollection(collection);
    }

    @Override
    public Collection<Link> marks() {
        return Optional.ofNullable(this.link).map(Collections::singleton).orElse(Collections.emptySet());
    }

    @Override
    public Set<String> markTypes() {
        return this.link != null ? Collections.singleton("link") : Collections.emptySet();
    }

    @Override
    public <T extends Link> Stream<? extends T> marks(Class<T> markClass) {
        return Stream.of(this.link).filter(markClass::isInstance).map(markClass::cast);
    }

    @Override
    public MediaInline mark(Link link) {
        return this.linkMark(Element.nonNull(link, "link"));
    }

    public MediaInline link(Link link) {
        return this.linkMark(Element.nonNull(link, "link"));
    }

    public MediaInline link(String href) {
        return this.linkMark(Link.link(href));
    }

    public MediaInline data(@Nullable Map<String, ?> data) {
        this.data = data != null ? FieldMap.immutableCopy(data) : null;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MediaInline id(String id) {
        this.id = MediaInline.validateId(id);
        return this;
    }

    public String collection() {
        return this.collection;
    }

    public MediaInline collection(String collection) {
        this.collection = MediaInline.validateCollection(collection);
        return this;
    }

    public Optional<String> occurrenceKey() {
        return Optional.ofNullable(this.occurrenceKey);
    }

    public MediaInline occurrenceKey(@Nullable String occurrenceKey) {
        this.occurrenceKey = MediaInline.validateOccurrenceKey(occurrenceKey);
        return this;
    }

    public static Partial.NeedsId mediaInline() {
        return new Partial.NeedsId(null);
    }

    public static Partial.NeedsId mediaInlineFile() {
        return new Partial.NeedsId(MediaType.FILE);
    }

    public static Partial.NeedsCollection mediaInlineFile(String id) {
        return new Partial.NeedsCollection(id, MediaType.FILE);
    }

    public static Partial.NeedsId mediaInlineLink() {
        return new Partial.NeedsId(MediaType.LINK);
    }

    public static Partial.NeedsCollection mediaInlineLink(String id) {
        return new Partial.NeedsCollection(id, MediaType.LINK);
    }

    public MediaInline file() {
        return this.mediaType(MediaType.FILE);
    }

    public MediaInline link() {
        return this.mediaType(MediaType.LINK);
    }

    public MediaInline mediaType(String mediaType) {
        return this.mediaType(MediaType.PARSER.parse(mediaType));
    }

    public MediaInline mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public MediaInline width(Number width) {
        Element.nonNull(width, "width");
        if (width.doubleValue() <= 0.0) {
            throw new MediaException.WidthMustBePositive(width);
        }
        this.width = width;
        return this;
    }

    public Optional<Number> height() {
        return Optional.ofNullable(this.height);
    }

    public MediaInline height(Number height) {
        Element.nonNull(height, "height");
        if (height.doubleValue() <= 0.0) {
            throw new MediaException.HeightMustBePositive(height);
        }
        this.height = height;
        return this;
    }

    public MediaInline size(Number width, Number height) {
        return this.width(width).height(height);
    }

    public MediaInline alt(@Nullable String alt) {
        this.alt = alt;
        return this;
    }

    public MediaInline linkMark(@Nullable Link link) {
        this.link = link;
        return this;
    }

    public MediaInline linkMark(@Nullable URL url) {
        return this.linkMark(url != null ? Link.link(url) : null);
    }

    public MediaInline linkMark(@Nullable String href) {
        return this.linkMark(href != null ? Link.link(href) : null);
    }

    public Optional<Link> linkMark() {
        return Optional.ofNullable(this.link);
    }

    public Optional<Map<String, ?>> data() {
        return Optional.ofNullable(this.data);
    }

    public static MediaInline mediaInline(String id, String collection) {
        return new MediaInline(id, collection);
    }

    public static MediaInline mediaInline(String id, @Nullable MediaType mediaType, String collection) {
        MediaInline mediaInline = new MediaInline(id, collection);
        if (mediaType != null) {
            mediaInline.mediaType(mediaType);
        }
        return mediaInline;
    }

    @Override
    public MediaInline copy() {
        return MediaInline.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mediaInline";
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaInline that = (MediaInline)o;
        return this.id.equals(that.id) && this.collection.equals(that.collection) && Objects.equals(this.occurrenceKey, that.occurrenceKey) && Objects.equals(this.alt, that.alt) && Objects.equals(this.link, that.link) && MediaInline.numberEq(this.width, that.width) && MediaInline.numberEq(this.height, that.height);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.collection, this.occurrenceKey, MediaInline.numberHash(this.width), MediaInline.numberHash(this.height), this.alt, this.link);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MediaInline{id=").append(this.id).append(", collection=").append(this.collection);
        if (this.mediaType != null) {
            sb.append(", mediaType=").append((Object)this.mediaType);
        }
        if (this.occurrenceKey != null) {
            sb.append(", occurrenceKey=").append(this.occurrenceKey);
        }
        if (this.width != null) {
            sb.append(", width=").append(this.width);
        }
        if (this.height != null) {
            sb.append(", height=").append(this.height);
        }
        if (this.alt != null) {
            sb.append(", alt=").append(this.alt);
        }
        if (this.link != null) {
            sb.append(", link=").append(this.link);
        }
        if (this.data != null) {
            sb.append(", data=").append(this.data);
        }
        return sb.append('}').toString();
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("id", this.id).add("collection", this.collection).addMappedIfPresent("type", this.mediaType, MediaType::mediaType).addIfPresent("occurrenceKey", this.occurrenceKey).addIfPresent("width", this.width).addIfPresent("height", this.height).addIfPresent("alt", this.alt).addIfPresent("data", this.data)).addMappedIfPresent("marks", this.link, lnk -> Collections.singletonList(lnk.toMap()));
    }

    private static MediaInline parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mediaInline");
        String id = (String)ParserSupport.getAttrOrThrow(map, "id");
        String collection = (String)ParserSupport.getAttrOrThrow(map, "collection");
        MediaInline mediaInline = new MediaInline(id, collection);
        ParserSupport.getAttrNumber(map, "width").ifPresent(mediaInline::width);
        ParserSupport.getAttrNumber(map, "height").ifPresent(mediaInline::height);
        ParserSupport.getAttr(map, "type", String.class).ifPresent(mediaInline::mediaType);
        ParserSupport.getAttr(map, "alt", String.class).ifPresent(mediaInline::alt);
        ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(mediaInline::occurrenceKey);
        ParserSupport.getAttr(map, "data").ifPresent(data -> mediaInline.data((Map)Cast.unsafeCast(data)));
        MarkParserSupport.parseLinkMark(map, mediaInline);
        return mediaInline;
    }

    private static String validateId(String id) {
        return Element.nonEmpty(id, "id");
    }

    private static String validateCollection(String collection) {
        return Element.nonNull(collection, "collection");
    }

    @Nullable
    private static String validateOccurrenceKey(@Nullable String occurrenceKey) {
        return Element.nullOrNonEmpty(occurrenceKey, "occurrenceKey");
    }

    public static enum MediaType {
        FILE("file"),
        LINK("link");

        static final EnumParser<MediaType> PARSER;
        private final String mediaType;

        private MediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public String mediaType() {
            return this.mediaType;
        }

        static {
            PARSER = new EnumParser<MediaType>(MediaType.class, MediaType::mediaType);
        }
    }

    public static interface Partial {

        public static class NeedsCollection
        extends CanSetMediaType<NeedsCollection> {
            private final String id;

            NeedsCollection(String id, @Nullable MediaType mediaType) {
                super(mediaType);
                this.id = Element.nonNull(id, "id");
            }

            @CheckReturnValue
            public MediaInline collection(String collection) {
                MediaInline mediaInline = new MediaInline(this.id, collection);
                if (this.mediaType != null) {
                    mediaInline.mediaType(this.mediaType);
                }
                return mediaInline;
            }
        }

        public static class NeedsId
        extends CanSetMediaType<NeedsId> {
            NeedsId() {
                this(null);
            }

            NeedsId(@Nullable MediaType mediaType) {
                super(mediaType);
            }

            public NeedsCollection id(String id) {
                return new NeedsCollection(id, this.mediaType);
            }
        }

        public static abstract class CanSetMediaType<T extends CanSetMediaType<T>> {
            @Nullable
            protected MediaType mediaType;

            CanSetMediaType(@Nullable MediaType mediaType) {
                this.mediaType = mediaType;
            }

            public T file() {
                return this.mediaType(MediaType.FILE);
            }

            public T link() {
                return this.mediaType(MediaType.LINK);
            }

            public T mediaType(String mediaType) {
                return this.mediaType(MediaType.PARSER.parse(mediaType));
            }

            public T mediaType(MediaType mediaType) {
                this.mediaType = mediaType;
                return (T)((CanSetMediaType)Cast.unsafeCast(this));
            }
        }
    }
}

