/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.LayoutSectionException;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.LayoutColumn;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class LayoutSection
extends AbstractContentNode<LayoutSection, LayoutColumn>
implements Marked<LayoutSection, Breakout>,
DocContent {
    public static final int MINIMUM_LAYOUT_COLUMN_COUNT = 2;
    public static final int MAXIMUM_LAYOUT_COLUMN_COUNT = 3;
    static final Factory<LayoutSection> FACTORY = new Factory<LayoutSection>("layoutSection", LayoutSection.class, LayoutSection::parse);
    private final MarkHolder<Breakout> marks = MarkHolder.unlimited();

    private LayoutSection() {
    }

    public static Partial.NeedsFirstColumn layoutSection() {
        return new Partial.NeedsFirstColumn();
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2});
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2, col3});
    }

    @Override
    public LayoutSection copy() {
        return LayoutSection.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "layoutSection";
    }

    @Override
    public Collection<Breakout> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends Breakout> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public LayoutSection mark(Breakout mark) {
        this.marks.add(mark);
        return this;
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public LayoutSection breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public LayoutSection wide() {
        return this.breakout(Breakout.wide());
    }

    public LayoutSection fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public LayoutSection defaultWidth() {
        return this.breakout(null);
    }

    @Override
    protected void validateContentNodeForAppend(LayoutColumn node) {
        if (this.content.size() >= 3) {
            throw new LayoutSectionException.TooManyLayoutColumns(4);
        }
    }

    @Override
    public void validate() {
        this.requireTwoOrThreeColumns();
        super.validate();
    }

    private void requireTwoOrThreeColumns() {
        int count = this.content.size();
        if (count < 2) {
            throw new LayoutSectionException.NotEnoughLayoutColumns(count);
        }
        if (count > 3) {
            throw new LayoutSectionException.TooManyLayoutColumns(count);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireTwoOrThreeColumns();
        return this.mapWithType().let(this::addContent).let(this.marks::addToMap);
    }

    private static LayoutSection parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "layoutSection");
        LayoutSection layoutSection = (LayoutSection)new LayoutSection().parseOptionalContent(map, LayoutColumn.class);
        layoutSection.requireTwoOrThreeColumns();
        MarkParserSupport.parseBreakoutMark(map, layoutSection);
        return layoutSection;
    }

    public static interface Partial {

        public static class NeedsSecondColumn {
            private final LayoutColumn col1;

            NeedsSecondColumn(LayoutColumn col1) {
                this.col1 = Objects.requireNonNull(col1, "col1");
            }

            public LayoutSection content(LayoutColumn col2) {
                return LayoutSection.layoutSection(this.col1, col2);
            }

            public LayoutSection content(LayoutColumn col2, LayoutColumn col3) {
                return LayoutSection.layoutSection(this.col1, col2, col3);
            }
        }

        public static class NeedsFirstColumn {
            NeedsFirstColumn() {
            }

            public NeedsSecondColumn content(LayoutColumn col1) {
                return new NeedsSecondColumn(col1);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2) {
                return LayoutSection.layoutSection(col1, col2);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3) {
                return LayoutSection.layoutSection(col1, col2, col3);
            }
        }
    }
}

