/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.mark.MarkException;
import com.atlassian.adf.model.mark.Alignment;
import com.atlassian.adf.model.mark.Annotation;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.Code;
import com.atlassian.adf.model.mark.DataConsumer;
import com.atlassian.adf.model.mark.Em;
import com.atlassian.adf.model.mark.Fragment;
import com.atlassian.adf.model.mark.Indentation;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.Strike;
import com.atlassian.adf.model.mark.Strong;
import com.atlassian.adf.model.mark.SubSup;
import com.atlassian.adf.model.mark.TextColor;
import com.atlassian.adf.model.mark.Underline;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.mark.unsupported.UnsupportedTextMark;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MarkParserSupport {
    private static final Map<String, Factory<? extends Mark>> MARK_MAP = Factory.extractLookupMap(Factory::type, Alignment.FACTORY, Annotation.FACTORY, Breakout.FACTORY, Code.FACTORY, DataConsumer.FACTORY, Em.FACTORY, Fragment.FACTORY, Indentation.FACTORY, Link.FACTORY, Strike.FACTORY, Strong.FACTORY, SubSup.FACTORY, TextColor.FACTORY, Underline.FACTORY);

    private MarkParserSupport() {
    }

    private static <M extends Mark> M parseMark(Map<String, ?> map, Class<M> expectedMarkClass, @Nullable Factory<M> unsupportedMarkFactory) {
        String type = ParserSupport.getTypeOrThrow(map);
        return (M)AdfException.frame("." + type, () -> {
            Factory<? extends Mark> factory = MARK_MAP.getOrDefault(type, unsupportedMarkFactory);
            if (factory == null) {
                throw new MarkException.TypeUnsupported(expectedMarkClass, type);
            }
            Mark mark = factory.parse(map);
            if (!expectedMarkClass.isInstance(mark)) {
                throw new MarkException.TypeMismatch(expectedMarkClass, type);
            }
            return (Mark)expectedMarkClass.cast(mark);
        });
    }

    public static <M extends Mark> void parseMarks(Map<String, ?> nodeMap, Class<M> expectedMarkClass, @Nullable Factory<M> unsupportedMarkFactory, Marked<?, M> markedNode) {
        List markList = (List)Cast.unsafeCast(nodeMap.get("marks"));
        if (markList != null) {
            for (int i = 0; i < markList.size(); ++i) {
                Map markMap = (Map)markList.get(i);
                AdfException.frame(":marks[" + i + "]", () -> {
                    Object mark = MarkParserSupport.parseMark(markMap, expectedMarkClass, unsupportedMarkFactory);
                    markedNode.mark(mark);
                    return null;
                });
            }
        }
    }

    public static void parseTextMarks(Map<String, ?> map, Marked<?, TextMark> node) {
        MarkParserSupport.parseMarks(map, TextMark.class, UnsupportedTextMark.FACTORY, node);
    }

    public static void parsePositionMark(Map<String, ?> map, Marked<?, PositionMark> node) {
        MarkParserSupport.parseMarks(map, PositionMark.class, null, node);
    }

    public static void parseLinkMark(Map<String, ?> map, Marked<?, Link> node) {
        MarkParserSupport.parseMarks(map, Link.class, null, node);
    }

    public static void parseBreakoutMark(Map<String, ?> map, Marked<?, Breakout> node) {
        MarkParserSupport.parseMarks(map, Breakout.class, null, node);
    }

    public static void parseExtensionMarks(Map<String, ?> map, Marked<?, ExtensionMark> node) {
        MarkParserSupport.parseMarks(map, ExtensionMark.class, null, node);
    }
}

