/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.node.NodeException;
import java.util.Objects;

public abstract class MediaException
extends NodeException {
    private static final long serialVersionUID = 1L;

    MediaException(String message) {
        super(message);
    }

    public static class TooManyContentItems
    extends MediaException {
        private static final long serialVersionUID = 1L;
        private final int count;

        public TooManyContentItems(int count) {
            super("At most two content items are allowed: a 'media' and its optional 'caption': " + count);
            this.count = count;
        }

        public int count() {
            return this.count;
        }
    }

    public static class WidthMustBeValidPercentage
    extends MediaSizeException {
        private static final long serialVersionUID = 1L;
        private final Number width;

        public WidthMustBeValidPercentage(Number width) {
            super("The 'width' value must be a valid percentage from 0 to 100: " + width);
            this.width = width;
        }

        public Number width() {
            return this.width;
        }
    }

    public static class HeightMustBePositive
    extends MediaSizeException {
        private static final long serialVersionUID = 1L;
        private final Number height;

        public HeightMustBePositive(Number height) {
            super("The 'height' value must be positive: " + height);
            this.height = Objects.requireNonNull(height, "height");
        }

        public Number height() {
            return this.height;
        }
    }

    public static class WidthMustBePositive
    extends MediaSizeException {
        private static final long serialVersionUID = 1L;
        private final Number width;

        public WidthMustBePositive(Number width) {
            super("The 'width' value must be positive: " + width);
            this.width = Objects.requireNonNull(width, "width");
        }

        public Number width() {
            return this.width;
        }
    }

    public static abstract class MediaSizeException
    extends MediaException {
        private static final long serialVersionUID = 1L;

        MediaSizeException(String message) {
            super(message);
        }
    }
}

