/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.node.Node;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ContentNode<C extends ContentNode<C, N>, N extends Node>
extends Node {
    public C copy();

    public boolean isEmpty();

    public List<N> content();

    default public C content(N content) {
        return this.content(Stream.of(content));
    }

    default public C content(N ... content) {
        Objects.requireNonNull(content, "content");
        return this.content(Arrays.stream(content));
    }

    default public C content(Iterable<? extends N> content) {
        Objects.requireNonNull(content, "content");
        return this.content(StreamSupport.stream(content.spliterator(), false));
    }

    public C content(Stream<? extends N> var1);

    public Stream<Node> allNodes();

    public C clear();

    public void removeIf(Predicate<? super N> var1);

    public void replaceContent(List<? extends N> var1);

    default public <T extends Node> Stream<T> allNodesOfType(Class<T> nodeClass) {
        return this.allNodes().filter(nodeClass::isInstance).map(nodeClass::cast);
    }

    default public <T extends Node> List<T> allNodesOfTypeAsList(Class<T> nodeClass) {
        return this.allNodesOfType(nodeClass).collect(Collectors.toList());
    }

    public void transformContent(Function<? super N, ? extends N> var1);

    public <T extends Node> void transformDescendants(Class<T> var1, Function<? super T, ? extends T> var2);
}

