/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Status
extends AbstractNode
implements CaptionContent,
InlineContent {
    static final Factory<Status> FACTORY = new Factory<Status>("status", Status.class, Status::parse);
    private Color color;
    private String text;
    @Nullable
    private String localId;
    @Nullable
    private String style;

    private Status(Color color, String text) {
        this.color = Element.nonNull(color, "color");
        this.text = Status.validateText(text);
    }

    public static Status status(Color color, String text) {
        return new Status(color, text);
    }

    @CheckReturnValue
    public static Partial.NeedsColor status() {
        return new Partial.NeedsColor();
    }

    @CheckReturnValue
    public static Partial.NeedsText status(Color color) {
        return new Partial.NeedsText(color);
    }

    public static Status neutral(String text) {
        return new Status(Color.NEUTRAL, text);
    }

    public static Status purple(String text) {
        return new Status(Color.PURPLE, text);
    }

    public static Status blue(String text) {
        return new Status(Color.BLUE, text);
    }

    public static Status red(String text) {
        return new Status(Color.RED, text);
    }

    public static Status yellow(String text) {
        return new Status(Color.YELLOW, text);
    }

    public static Status green(String text) {
        return new Status(Color.GREEN, text);
    }

    public Color color() {
        return this.color;
    }

    public Status color(Color color) {
        this.color = Element.nonNull(color, "color");
        return this;
    }

    public Status neutral() {
        return this.color(Color.NEUTRAL);
    }

    public Status purple() {
        return this.color(Color.PURPLE);
    }

    public Status blue() {
        return this.color(Color.BLUE);
    }

    public Status red() {
        return this.color(Color.RED);
    }

    public Status yellow() {
        return this.color(Color.YELLOW);
    }

    public Status green() {
        return this.color(Color.GREEN);
    }

    public Status text(String text) {
        this.text = Status.validateText(text);
        return this;
    }

    public String text() {
        return this.text;
    }

    public Status localId(String localId) {
        this.localId = localId;
        return this;
    }

    public Status style(String style) {
        this.style = style;
        return this;
    }

    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Optional<String> style() {
        return Optional.ofNullable(this.style);
    }

    @Override
    public Status copy() {
        return Status.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "status";
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return this.color == status.color && this.text.equals(status.text) && Objects.equals(this.localId, status.localId) && Objects.equals(this.style, status.style);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.text, this.localId, this.style});
    }

    @Override
    public String toString() {
        return "Status{color=" + this.color + ", text=" + this.text + ", localId=" + this.localId + ", style=" + this.style + "}";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("color", this.color.color).add("text", this.text).addIfPresent("localId", this.localId).addIfPresent("style", this.style));
    }

    private static Status parse(Map<String, ?> map) {
        Color color = Color.PARSER.parse((String)ParserSupport.getAttrOrThrow(map, "color"));
        String text = (String)ParserSupport.getAttrOrThrow(map, "text");
        Status status = new Status(color, text);
        ParserSupport.getAttr(map, "localId", String.class).ifPresent(status::localId);
        ParserSupport.getAttr(map, "style", String.class).ifPresent(status::style);
        return status;
    }

    private static String validateText(String text) {
        return Element.nonEmpty(text, "text");
    }

    public static interface Partial {

        public static class NeedsText {
            private final Color color;

            public NeedsText(Color color) {
                this.color = Element.nonNull(color, "color");
            }

            public Status text(String text) {
                return new Status(this.color, text);
            }
        }

        public static class NeedsColor {
            NeedsColor() {
            }

            @CheckReturnValue
            public NeedsText color(Color color) {
                return new NeedsText(color);
            }

            @CheckReturnValue
            public NeedsText neutral() {
                return new NeedsText(Color.NEUTRAL);
            }

            @CheckReturnValue
            public NeedsText purple() {
                return new NeedsText(Color.PURPLE);
            }

            @CheckReturnValue
            public NeedsText blue() {
                return new NeedsText(Color.BLUE);
            }

            @CheckReturnValue
            public NeedsText red() {
                return new NeedsText(Color.RED);
            }

            @CheckReturnValue
            public NeedsText yellow() {
                return new NeedsText(Color.YELLOW);
            }

            @CheckReturnValue
            public NeedsText green() {
                return new NeedsText(Color.GREEN);
            }
        }
    }

    public static enum Color {
        NEUTRAL("neutral"),
        PURPLE("purple"),
        BLUE("blue"),
        RED("red"),
        YELLOW("yellow"),
        GREEN("green");

        static final EnumParser<Color> PARSER;
        private final String color;

        private Color(String color) {
            this.color = color;
        }

        public String color() {
            return this.color;
        }

        static {
            PARSER = new EnumParser<Color>(Color.class, Color::color);
        }
    }
}

