/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Functions;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public interface Media
extends Node,
Marked<Media, Link> {
    public static final Factory<Media> FACTORY = new Factory<Media>("media", Media.class, AbstractMedia::parse);

    @CheckReturnValue
    public static Partial.NeedsType media() {
        return new Partial.NeedsType();
    }

    @CheckReturnValue
    public static Partial.FileNeedsId fileMedia() {
        return new Partial.FileNeedsId();
    }

    @CheckReturnValue
    public static Partial.FileNeedsCollection fileMedia(String id) {
        return new Partial.FileNeedsCollection(id);
    }

    public static FileMedia fileMedia(String id, String collection) {
        return new FileMedia(id, collection);
    }

    @CheckReturnValue
    public static Partial.LinkNeedsId linkMedia() {
        return new Partial.LinkNeedsId();
    }

    @CheckReturnValue
    public static Partial.LinkNeedsCollection linkMedia(String id) {
        return new Partial.LinkNeedsCollection(id);
    }

    public static LinkMedia linkMedia(String id, String collection) {
        return new LinkMedia(id, collection);
    }

    @CheckReturnValue
    public static Partial.ExternalNeedsUrl externalMedia() {
        return new Partial.ExternalNeedsUrl();
    }

    public static ExternalMedia externalMedia(String url) {
        return Media.externalMedia().url(url);
    }

    public static ExternalMedia externalMedia(URL url) {
        return Media.externalMedia().url(url);
    }

    public static ExternalMedia externalMedia(URI url) {
        return Media.externalMedia().url(url);
    }

    public MediaType type();

    public Optional<Number> width();

    public Media width(@Nullable Number var1);

    public Optional<Number> height();

    public Media height(@Nullable Number var1);

    public Media size(@Nullable Number var1, @Nullable Number var2);

    public <R> R fold(Function<? super FileMedia, ? extends R> var1, Function<? super LinkMedia, ? extends R> var2, Function<? super ExternalMedia, ? extends R> var3);

    default public void accept(Consumer<? super FileMedia> ifFile, Consumer<? super LinkMedia> ifLink, Consumer<? super ExternalMedia> ifExternal) {
        this.fold(Functions.voidFn(ifFile), Functions.voidFn(ifLink), Functions.voidFn(ifExternal));
    }

    public Optional<String> alt();

    public Media alt(@Nullable String var1);

    public Media linkMark(@Nullable Link var1);

    public Media linkMark(@Nullable URL var1);

    public Media linkMark(@Nullable String var1);

    public Optional<Link> linkMark();

    public Optional<FileMedia> file();

    public Optional<LinkMedia> link();

    public Optional<ExternalMedia> external();

    default public void ifFile(Consumer<? super FileMedia> effect) {
        this.file().ifPresent(effect);
    }

    default public void ifLink(Consumer<? super LinkMedia> effect) {
        this.link().ifPresent(effect);
    }

    default public void ifExternal(Consumer<? super ExternalMedia> effect) {
        this.external().ifPresent(effect);
    }

    public static class ExternalMedia
    extends AbstractMedia<ExternalMedia> {
        private final String url;

        ExternalMedia(String url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public ExternalMedia copy() {
            return (ExternalMedia)Cast.unsafeCast(ExternalMedia.parse(this.toMap()));
        }

        public String url() {
            return this.url;
        }

        @Override
        public MediaType type() {
            return MediaType.EXTERNAL;
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifExternal.apply(this);
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.empty();
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.empty();
        }

        @Override
        public Optional<ExternalMedia> external() {
            return Optional.of(this);
        }

        @Override
        public Map<String, ?> toMap() {
            return this.mapWithType().add("attrs", FieldMap.map().add("type", MediaType.EXTERNAL.mediaType()).add("url", this.url).let(this::addCommonAttrs));
        }

        static ExternalMedia parseExternal(Map<String, ?> map) {
            String url = ParserSupport.getAttrOrThrow(map, "url", String.class);
            return new ExternalMedia(url);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalMedia other = (ExternalMedia)o;
            return ((ExternalMedia)o).url.equals(this.url) && this.commonEquals(other);
        }

        @Override
        public int hashCode() {
            return this.url.hashCode() * 31 + this.commonHashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Media{type=external, url='").append(this.url).append('\'');
            this.commonToString(sb);
            return sb.append('}').toString();
        }
    }

    public static class LinkMedia
    extends FileOrLinkMedia<LinkMedia> {
        LinkMedia(String id, String collection) {
            super(id, collection);
        }

        @Override
        public LinkMedia copy() {
            return (LinkMedia)Cast.unsafeCast(LinkMedia.parse(this.toMap()));
        }

        @Override
        public MediaType type() {
            return MediaType.LINK;
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.empty();
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.of(this);
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifLink.apply(this);
        }

        static LinkMedia parseLink(Map<String, ?> map) {
            String id = (String)ParserSupport.getAttrOrThrow(map, "id");
            String collection = (String)ParserSupport.getAttrOrThrow(map, "collection");
            LinkMedia media = new LinkMedia(id, collection);
            ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(media::occurrenceKey);
            return media;
        }
    }

    public static class FileMedia
    extends FileOrLinkMedia<FileMedia> {
        FileMedia(String id, String collection) {
            super(id, collection);
        }

        @Override
        public FileMedia copy() {
            return (FileMedia)Cast.unsafeCast(FileMedia.parse(this.toMap()));
        }

        @Override
        public MediaType type() {
            return MediaType.FILE;
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.of(this);
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.empty();
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifFile.apply(this);
        }

        static FileMedia parseFile(Map<String, ?> map) {
            String id = (String)ParserSupport.getAttrOrThrow(map, "id");
            String collection = (String)ParserSupport.getAttrOrThrow(map, "collection");
            FileMedia media = new FileMedia(id, collection);
            ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(media::occurrenceKey);
            return media;
        }
    }

    public static abstract class FileOrLinkMedia<T extends FileOrLinkMedia<T>>
    extends AbstractMedia<T> {
        protected String id;
        protected String collection;
        @Nullable
        protected String occurrenceKey;

        FileOrLinkMedia(String id, String collection) {
            this.id = FileOrLinkMedia.validateId(id);
            this.collection = Element.nonNull(collection, "collection");
        }

        public T id(String id) {
            this.id = FileOrLinkMedia.validateId(id);
            return (T)((FileOrLinkMedia)this.self());
        }

        public T collection(String collection) {
            this.collection = Element.nonNull(collection, "collection");
            return (T)((FileOrLinkMedia)this.self());
        }

        public String id() {
            return this.id;
        }

        public String collection() {
            return this.collection;
        }

        public Optional<String> occurrenceKey() {
            return Optional.ofNullable(this.occurrenceKey);
        }

        public T occurrenceKey(@Nullable String occurrenceKey) {
            this.occurrenceKey = FileOrLinkMedia.validateOccurrenceKey(occurrenceKey);
            return (T)((FileOrLinkMedia)this.self());
        }

        @Override
        public Optional<ExternalMedia> external() {
            return Optional.empty();
        }

        @Override
        public Map<String, ?> toMap() {
            return this.mapWithType().add("attrs", FieldMap.map().add("type", this.type().mediaType()).add("id", this.id).add("collection", this.collection).addIfPresent("occurrenceKey", this.occurrenceKey).let(this::addCommonAttrs)).addMappedIfPresent("marks", this.link, lm -> Collections.singletonList(lm.toMap()));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileOrLinkMedia other = (FileOrLinkMedia)o;
            return this.id.equals(other.id) && this.type() == other.type() && this.collection.equals(other.collection) && Objects.equals(this.occurrenceKey, other.occurrenceKey) && this.commonEquals(other);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.collection, this.occurrenceKey) * 31 + this.commonHashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{id=").append(this.id).append(", collection=").append(this.collection);
            if (this.occurrenceKey != null) {
                sb.append(", occurrenceKey=").append(this.occurrenceKey);
            }
            this.commonToString(sb);
            return sb.append('}').toString();
        }

        private static String validateId(String id) {
            return Element.nonEmpty(id, "id");
        }

        @Nullable
        private static String validateOccurrenceKey(@Nullable String occurrenceKey) {
            return Element.nullOrNonEmpty(occurrenceKey, "occurrenceKey");
        }
    }

    public static abstract class AbstractMedia<N extends AbstractMedia<N>>
    extends AbstractNode
    implements Media {
        @Nullable
        protected Number width;
        @Nullable
        protected Number height;
        @Nullable
        protected String alt;
        @Nullable
        protected Link link;

        @Override
        public N mark(Link link) {
            return (N)this.linkMark(Element.nonNull(link, "link"));
        }

        public N linkMark(@Nullable Link link) {
            this.link = link;
            return this.self();
        }

        public N linkMark(@Nullable URL url) {
            return (N)this.linkMark(url != null ? Link.link(url) : null);
        }

        public N linkMark(@Nullable String href) {
            return (N)this.linkMark(href != null ? Link.link(href) : null);
        }

        @Override
        public Optional<Link> linkMark() {
            return Optional.ofNullable(this.link);
        }

        @Override
        public Collection<Link> marks() {
            return Optional.ofNullable(this.link).map(Collections::singleton).orElse(Collections.emptySet());
        }

        @Override
        public Set<String> markTypes() {
            return Optional.ofNullable(this.link).map(l -> Collections.singleton(l.elementType())).orElse(Collections.emptySet());
        }

        @Override
        public <T extends Link> Stream<? extends T> marks(Class<T> markClass) {
            return Stream.of(this.link).filter(markClass::isInstance).map(markClass::cast);
        }

        @Override
        public Optional<Number> width() {
            return Optional.ofNullable(this.width);
        }

        public N width(@Nullable Number width) {
            if (width != null && width.doubleValue() <= 0.0) {
                throw new MediaException.WidthMustBePositive(width);
            }
            this.width = width;
            return this.self();
        }

        @Override
        public Optional<Number> height() {
            return Optional.ofNullable(this.height);
        }

        public N height(@Nullable Number height) {
            if (height != null && height.doubleValue() <= 0.0) {
                throw new MediaException.HeightMustBePositive(height);
            }
            this.height = height;
            return this.self();
        }

        public N size(@Nullable Number width, @Nullable Number height) {
            return (N)((AbstractMedia)this.width(width)).height(height);
        }

        @Override
        public Optional<String> alt() {
            return Optional.ofNullable(this.alt);
        }

        public N alt(@Nullable String alt) {
            this.alt = alt;
            return this.self();
        }

        @Override
        public void accept(Consumer<? super FileMedia> ifFile, Consumer<? super LinkMedia> ifLink, Consumer<? super ExternalMedia> ifExternal) {
            this.fold(Functions.voidFn(ifFile), Functions.voidFn(ifLink), Functions.voidFn(ifExternal));
        }

        @Override
        public void ifFile(Consumer<? super FileMedia> effect) {
            this.file().ifPresent(effect);
        }

        @Override
        public void ifLink(Consumer<? super LinkMedia> effect) {
            this.link().ifPresent(effect);
        }

        @Override
        public void ifExternal(Consumer<? super ExternalMedia> effect) {
            this.external().ifPresent(effect);
        }

        @Override
        public String elementType() {
            return "media";
        }

        @Override
        public void validate() {
        }

        @Override
        public abstract boolean equals(@Nullable Object var1);

        protected final boolean commonEquals(AbstractMedia<?> other) {
            return Objects.equals(this.alt, other.alt) && Objects.equals(this.link, other.link) && AbstractMedia.numberEq(this.width, other.width) && AbstractMedia.numberEq(this.height, other.height);
        }

        @Override
        public abstract int hashCode();

        protected final int commonHashCode() {
            return Objects.hash(this.getClass(), AbstractMedia.numberHash(this.width), AbstractMedia.numberHash(this.height), this.alt, this.link);
        }

        @Override
        public abstract String toString();

        protected void commonToString(StringBuilder sb) {
            if (this.width != null) {
                sb.append(", width=").append(this.width);
            }
            if (this.height != null) {
                sb.append(", height=").append(this.height);
            }
            if (this.alt != null) {
                sb.append(", alt='").append(this.alt).append('\'');
            }
            if (this.link != null) {
                sb.append(", link=").append(this.link);
            }
        }

        protected void addCommonAttrs(FieldMap attrs) {
            attrs.addIfPresent("width", this.width);
            attrs.addIfPresent("height", this.height);
            attrs.addIfPresent("alt", this.alt);
        }

        protected void parseCommonAttrs(Map<String, ?> map) {
            ParserSupport.getAttrNumber(map, "width").ifPresent(number -> this.width((Number)number));
            ParserSupport.getAttrNumber(map, "height").ifPresent(number -> this.height((Number)number));
            ParserSupport.getAttr(map, "alt", String.class).ifPresent(string -> this.alt((String)string));
        }

        static Media parse(Map<String, ?> map) {
            ParserSupport.checkType(map, "media");
            MediaType type = MediaType.PARSER.parse(ParserSupport.getAttrOrThrow(map, "type", String.class));
            AbstractMedia<?> media = type.parse(map);
            media.parseCommonAttrs(map);
            MarkParserSupport.parseLinkMark(map, media);
            return media;
        }

        N self() {
            return (N)((AbstractMedia)Cast.unsafeCast(this));
        }
    }

    public static interface Partial {

        public static class ExternalNeedsUrl {
            public ExternalMedia url(String url) {
                ParserSupport.parseUri(url, "url");
                return new ExternalMedia(url);
            }

            public ExternalMedia url(URL url) {
                String s = Element.nonNull(url, "url").toString();
                ParserSupport.parseUri(s, "url");
                return new ExternalMedia(s);
            }

            public ExternalMedia url(URI url) {
                return new ExternalMedia(Element.nonNull(url, "url").toString());
            }
        }

        public static class LinkNeedsCollection {
            private final String id;

            LinkNeedsCollection(String id) {
                this.id = Element.nonNull(id, "id");
            }

            public LinkMedia collection(String collection) {
                return new LinkMedia(this.id, collection);
            }
        }

        public static class FileNeedsCollection {
            private final String id;

            FileNeedsCollection(String id) {
                this.id = Element.nonNull(id, "id");
            }

            public FileMedia collection(String collection) {
                return new FileMedia(this.id, collection);
            }
        }

        public static class LinkNeedsId {
            LinkNeedsId() {
            }

            @CheckReturnValue
            public LinkNeedsCollection id(String id) {
                return new LinkNeedsCollection(id);
            }
        }

        public static class FileNeedsId {
            FileNeedsId() {
            }

            @CheckReturnValue
            public FileNeedsCollection id(String id) {
                return new FileNeedsCollection(id);
            }
        }

        public static class NeedsType {
            NeedsType() {
            }

            public FileNeedsId file() {
                return new FileNeedsId();
            }

            public LinkNeedsId link() {
                return new LinkNeedsId();
            }

            public ExternalNeedsUrl external() {
                return new ExternalNeedsUrl();
            }
        }
    }

    public static enum MediaType {
        FILE("file", FileMedia::parseFile),
        LINK("link", LinkMedia::parseLink),
        EXTERNAL("external", ExternalMedia::parseExternal);

        static final EnumParser<MediaType> PARSER;
        private final String mediaType;
        private final Function<Map<String, ?>, ? extends AbstractMedia<?>> parser;

        private MediaType(String mediaType, Function<Map<String, ?>, ? extends AbstractMedia<?>> parser) {
            this.mediaType = mediaType;
            this.parser = parser;
        }

        public String mediaType() {
            return this.mediaType;
        }

        AbstractMedia<?> parse(Map<String, ?> map) {
            return this.parser.apply(map);
        }

        static {
            PARSER = new EnumParser<MediaType>(MediaType.class, MediaType::mediaType);
        }
    }
}

