/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class InlineExtension
extends AbstractNode
implements ExtensionNode<InlineExtension>,
InlineContent {
    static final Factory<InlineExtension> FACTORY = new Factory<InlineExtension>("inlineExtension", InlineExtension.class, InlineExtension::parse);
    private final ExtensionSettings settings;
    private final MarkHolder<ExtensionMark> marks = MarkHolder.unlimited();

    private InlineExtension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<InlineExtension> inlineExtension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<InlineExtension>(InlineExtension::new);
    }

    public static InlineExtension inlineExtension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(InlineExtension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public InlineExtension copy() {
        return InlineExtension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "inlineExtension";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs()).let(this.marks::addToMap);
    }

    @Override
    public void validate() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.settings, this.marks);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineExtension extension = (InlineExtension)o;
        return this.settings.equals(extension.settings) && this.marks.equals(extension.marks);
    }

    @Override
    public String toString() {
        return "InlineExtension{settings=" + this.settings + ", marks=" + this.marks + "}";
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public InlineExtension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public InlineExtension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public InlineExtension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public InlineExtension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public InlineExtension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    @Override
    public Collection<ExtensionMark> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends ExtensionMark> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public InlineExtension mark(ExtensionMark mark) {
        this.marks.add(mark);
        return this;
    }

    private static InlineExtension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        InlineExtension extension = new InlineExtension(settings);
        MarkParserSupport.parseExtensionMarks(map, extension);
        return extension;
    }
}

