/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Extension
extends AbstractNode
implements ExtensionNode<Extension>,
DocContent,
LayoutColumnContent,
NonNestableBlockContent,
TableCellContent {
    static final Factory<Extension> FACTORY = new Factory<Extension>("extension", Extension.class, Extension::parse);
    private final ExtensionSettings settings;
    private final MarkHolder<ExtensionMark> marks = MarkHolder.unlimited();
    @Nullable
    private ExtensionSettings.Layout layout;

    private Extension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<Extension> extension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<Extension>(Extension::new);
    }

    public static Extension extension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(Extension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public Extension copy() {
        return Extension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "extension";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs().addMappedIfPresent("layout", this.layout, ExtensionSettings.Layout::layout)).let(this.marks::addToMap);
    }

    @Override
    public void validate() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.settings, this.marks, this.layout});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension extension = (Extension)o;
        return this.layout == extension.layout && this.settings.equals(extension.settings) && this.marks.equals(extension.marks);
    }

    @Override
    public String toString() {
        return "Extension{settings=" + this.settings + ", layout=" + (Object)((Object)this.layout) + ", marks=" + this.marks + '}';
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public Extension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public Extension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public Extension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public Extension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public Extension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    public Extension layout(@Nullable String layout) {
        return this.layout(ExtensionSettings.Layout.PARSER.parseAllowNull(layout));
    }

    public Extension layout(@Nullable ExtensionSettings.Layout layout) {
        this.layout = layout;
        return this;
    }

    public Optional<ExtensionSettings.Layout> layout() {
        return Optional.ofNullable(this.layout);
    }

    @Override
    public Collection<ExtensionMark> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends ExtensionMark> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public Extension mark(ExtensionMark mark) {
        this.marks.add(mark);
        return this;
    }

    private static Extension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        Extension extension = new Extension(settings);
        ParserSupport.getAttr(map, "layout", String.class).ifPresent(layout -> extension.layout(ExtensionSettings.Layout.PARSER.parse((String)layout)));
        MarkParserSupport.parseExtensionMarks(map, extension);
        return extension;
    }
}

