/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Breakout
extends AbstractMark {
    private static final Breakout WIDE = new Breakout(Mode.WIDE);
    private static final Breakout FULL_WIDTH = new Breakout(Mode.FULL_WIDTH);
    static final Factory<Breakout> FACTORY = new Factory<Breakout>("breakout", Breakout.class, Breakout::parse);
    private final Mode mode;

    private Breakout(Mode mode) {
        this.mode = mode;
    }

    @Override
    public Breakout copy() {
        return this;
    }

    public static Breakout wide() {
        return WIDE;
    }

    public static Breakout fullWidth() {
        return FULL_WIDTH;
    }

    @Override
    public String elementType() {
        return "breakout";
    }

    public Mode mode() {
        return this.mode;
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("mode", this.mode.mode()));
    }

    @Override
    public String toString() {
        return "Mark[breakout[mode=" + (Object)((Object)this.mode) + "]]";
    }

    private static Breakout parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "breakout");
        return Mode.PARSER.parse(ParserSupport.getAttrOrThrow(map, "mode", String.class)).toBreakout();
    }

    public static enum Mode {
        WIDE("wide", Breakout::wide),
        FULL_WIDTH("full-width", Breakout::fullWidth);

        private final String mode;
        private final Supplier<Breakout> toBreakout;
        static final EnumParser<Mode> PARSER;

        private Mode(String mode, Supplier<Breakout> toBreakout) {
            this.mode = mode;
            this.toBreakout = toBreakout;
        }

        public String mode() {
            return this.mode;
        }

        Breakout toBreakout() {
            return this.toBreakout.get();
        }

        static {
            PARSER = new EnumParser<Mode>(Mode.class, Mode::mode);
        }
    }
}

