/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.HeadingException;
import com.atlassian.adf.model.mark.Alignment;
import com.atlassian.adf.model.mark.Indentation;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class Heading
extends AbstractContentNode<Heading, InlineContent>
implements Marked<Heading, PositionMark>,
DocContent,
LayoutColumnContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static Factory<Heading> FACTORY = new Factory<Heading>("heading", Heading.class, Heading::parse);
    private int level;
    private final MarkHolder<PositionMark> marks = MarkHolder.limit(1);

    private Heading(int level) {
        this.level = Heading.validateLevel(level);
    }

    public static Heading h1() {
        return new Heading(1);
    }

    public static Heading h1(String content) {
        return Heading.h1().content(content);
    }

    public static Heading h1(String ... content) {
        return Heading.h1().content(content);
    }

    public static Heading h1(InlineContent content) {
        return (Heading)Heading.h1().content(content);
    }

    public static Heading h1(InlineContent ... content) {
        return (Heading)Heading.h1().content(content);
    }

    public static Heading h1(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h1().content(content);
    }

    public static Heading h1(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h1().content(content);
    }

    public static Heading h2() {
        return new Heading(2);
    }

    public static Heading h2(String content) {
        return Heading.h2().content(content);
    }

    public static Heading h2(String ... content) {
        return Heading.h2().content(content);
    }

    public static Heading h2(InlineContent content) {
        return (Heading)Heading.h2().content(content);
    }

    public static Heading h2(InlineContent ... content) {
        return (Heading)Heading.h2().content(content);
    }

    public static Heading h2(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h2().content(content);
    }

    public static Heading h2(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h2().content(content);
    }

    public static Heading h3() {
        return new Heading(3);
    }

    public static Heading h3(String content) {
        return Heading.h3().content(content);
    }

    public static Heading h3(String ... content) {
        return Heading.h3().content(content);
    }

    public static Heading h3(InlineContent content) {
        return (Heading)Heading.h3().content(content);
    }

    public static Heading h3(InlineContent ... content) {
        return (Heading)Heading.h3().content(content);
    }

    public static Heading h3(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h3().content(content);
    }

    public static Heading h3(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h3().content(content);
    }

    public static Heading h4() {
        return new Heading(4);
    }

    public static Heading h4(String content) {
        return Heading.h4().content(content);
    }

    public static Heading h4(String ... content) {
        return Heading.h4().content(content);
    }

    public static Heading h4(InlineContent content) {
        return (Heading)Heading.h4().content(content);
    }

    public static Heading h4(InlineContent ... content) {
        return (Heading)Heading.h4().content(content);
    }

    public static Heading h4(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h4().content(content);
    }

    public static Heading h4(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h4().content(content);
    }

    public static Heading h5() {
        return new Heading(5);
    }

    public static Heading h5(String content) {
        return Heading.h5().content(content);
    }

    public static Heading h5(String ... content) {
        return Heading.h5().content(content);
    }

    public static Heading h5(InlineContent content) {
        return (Heading)Heading.h5().content(content);
    }

    public static Heading h5(InlineContent ... content) {
        return (Heading)Heading.h5().content(content);
    }

    public static Heading h5(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h5().content(content);
    }

    public static Heading h5(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h5().content(content);
    }

    public static Heading h6() {
        return new Heading(6);
    }

    public static Heading h6(String content) {
        return Heading.h6().content(content);
    }

    public static Heading h6(String ... content) {
        return Heading.h6().content(content);
    }

    public static Heading h6(InlineContent content) {
        return (Heading)Heading.h6().content(content);
    }

    public static Heading h6(InlineContent ... content) {
        return (Heading)Heading.h6().content(content);
    }

    public static Heading h6(Iterable<? extends InlineContent> content) {
        return (Heading)Heading.h6().content(content);
    }

    public static Heading h6(Stream<? extends InlineContent> content) {
        return (Heading)Heading.h6().content(content);
    }

    public static Heading heading(int level) {
        return new Heading(level);
    }

    public static Heading heading(int level, String content) {
        return Heading.heading(level).content(content);
    }

    public static Heading heading(int level, String ... content) {
        return Heading.heading(level).content(content);
    }

    public static Heading heading(int level, InlineContent content) {
        return (Heading)Heading.heading(level).content(content);
    }

    public static Heading heading(int level, InlineContent ... content) {
        return (Heading)Heading.heading(level).content(content);
    }

    public static Heading heading(int level, Iterable<? extends InlineContent> content) {
        return (Heading)Heading.heading(level).content(content);
    }

    public static Heading heading(int level, Stream<? extends InlineContent> content) {
        return (Heading)Heading.heading(level).content(content);
    }

    public Heading level(int level) {
        this.level = Heading.validateLevel(level);
        return this;
    }

    @Override
    public Heading content(String content) {
        return (Heading)this.content(Text.text(content));
    }

    @Override
    public Heading content(String ... content) {
        return (Heading)this.content(Text.text(content));
    }

    @Override
    public Collection<PositionMark> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends PositionMark> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public Heading mark(PositionMark mark) {
        this.marks.add(mark);
        return this;
    }

    public Heading center() {
        this.mark(Alignment.center());
        return this;
    }

    public Heading end() {
        this.mark(Alignment.end());
        return this;
    }

    public Heading indentation(int level) {
        this.mark(Indentation.indentation(level));
        return this;
    }

    public int level() {
        return this.level;
    }

    @Override
    public String elementType() {
        return "heading";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        Heading other = (Heading)o;
        return this.level == other.level && this.marks.equals(other.marks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level, this.marks);
    }

    @Override
    public void validate() {
        super.validate();
        this.marks.validate();
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).let(this.marks::addToMap).add("attrs", FieldMap.map("level", this.level));
    }

    private static Heading parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "heading");
        int level = ParserSupport.getAttrIntOrThrow(map, "level");
        Heading heading = (Heading)Heading.heading(level).parseOptionalContent(map, InlineContent.class);
        MarkParserSupport.parsePositionMark(map, heading);
        return heading;
    }

    void disableMarks(ContentNode<?, ?> parent) {
        this.marks.disable(parent.elementType());
    }

    private static int validateLevel(int level) {
        if (level < 1 || level > 6) {
            throw new HeadingException.InvalidLevel(level);
        }
        return level;
    }
}

