/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.ex.mark.TextColorException;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class TextColor
extends AbstractMark
implements FormattedTextMark {
    private static final Pattern REGEX_VALID_COLOR = Pattern.compile("^#[0-9a-fA-F]{6}$");
    static final Factory<TextColor> FACTORY = new Factory<TextColor>("textColor", TextColor.class, TextColor::parse);
    private final String color;

    private TextColor(String color) {
        this.color = Objects.requireNonNull(color, "color");
        if (!REGEX_VALID_COLOR.matcher(color).matches()) {
            throw new TextColorException.InvalidColor(color);
        }
    }

    public static TextColor textColor(String color) {
        return new TextColor(color);
    }

    public String color() {
        return this.color;
    }

    @Override
    public String elementType() {
        return "textColor";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("color", this.color));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof TextColor && this.color.equals(((TextColor)o).color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    private static TextColor parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "textColor");
        String color = (String)ParserSupport.getAttrOrThrow(map, "color");
        return TextColor.textColor(color);
    }
}

