/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.jackson2;

import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.parser.AdfParser;
import com.atlassian.adf.parser.JsonParser;
import com.atlassian.annotations.PublicApi;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@PublicApi
public class AdfJackson2
implements AdfParser<String> {
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper mapper;
    private final JsonParser jsonParser;
    private final boolean pretty;

    public AdfJackson2() {
        this(new ObjectMapper(), false);
    }

    public AdfJackson2(ObjectMapper mapper) {
        this(mapper, false);
    }

    public AdfJackson2(ObjectMapper mapper, boolean pretty) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.pretty = pretty;
        this.jsonParser = new Jackson2JsonParser(pretty);
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public JsonParser jsonParser() {
        return this.jsonParser;
    }

    public String marshall(Doc doc) {
        Map map = doc.toMap();
        return this.jsonParser.toJson(map);
    }

    public Doc unmarshall(String json) {
        Map map = this.jsonParser.fromJson(json);
        return Doc.parse((Map)map);
    }

    public AdfParser<JsonNode> useJsonNode() {
        return new UseJsonNode();
    }

    public AdfJackson2 pretty() {
        return this.pretty ? this : new AdfJackson2(this.mapper, true);
    }

    private class Jackson2JsonParser
    implements JsonParser {
        private final boolean pretty;

        Jackson2JsonParser(boolean pretty) {
            this.pretty = pretty;
        }

        public String toJson(Map<String, ?> map) {
            try {
                return this.pretty ? AdfJackson2.this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map) : AdfJackson2.this.mapper.writeValueAsString(map);
            }
            catch (IOException e) {
                throw new IllegalStateException("Invalid JSON output", e);
            }
        }

        public Map<String, ?> fromJson(String json) {
            try {
                return (Map)AdfJackson2.this.mapper.readValue(json, TYPE_REFERENCE);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON input", e);
            }
        }
    }

    private class UseJsonNode
    implements AdfParser<JsonNode> {
        private UseJsonNode() {
        }

        public JsonParser jsonParser() {
            return AdfJackson2.this.jsonParser;
        }

        public JsonNode marshall(Doc doc) {
            Map map = doc.toMap();
            return AdfJackson2.this.mapper.valueToTree((Object)map);
        }

        public Doc unmarshall(JsonNode json) {
            if (!json.isObject()) {
                throw new IllegalArgumentException("Invalid JSON input: " + json.asToken());
            }
            Map map = (Map)AdfJackson2.this.mapper.convertValue((Object)json, TYPE_REFERENCE);
            return Doc.parse((Map)map);
        }
    }
}

