/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.ElementResolver;
import com.atlassian.adf.html.parser.HtmlConverter;
import com.atlassian.adf.html.parser.TextParser;
import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.parser.AdfUnmarshaller;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class HtmlParser
implements AdfUnmarshaller<String> {
    private static final Consumer<String> IGNORE = ignore -> {};
    private boolean keepWhitespace;
    private Consumer<String> languageCallback = IGNORE;
    private Consumer<String> fallbackReporter = IGNORE;

    boolean keepWhitespace() {
        return this.keepWhitespace;
    }

    HtmlParser keepWhitespace(boolean keepWhitespace) {
        this.keepWhitespace = keepWhitespace;
        return this;
    }

    Consumer<String> languageCallback() {
        return this.languageCallback;
    }

    HtmlParser languageCallback(@Nullable Consumer<String> languageCallback) {
        this.languageCallback = languageCallback != null ? languageCallback : IGNORE;
        return this;
    }

    Consumer<String> fallbackReporter() {
        return this.fallbackReporter;
    }

    public HtmlParser fallbackReporter(@Nullable Consumer<String> fallbackReporter) {
        this.fallbackReporter = fallbackReporter != null ? fallbackReporter : IGNORE;
        return this;
    }

    Stream<? extends Node> parseChildren(org.jsoup.nodes.Node html) {
        return html.childNodes().stream().flatMap(this::parseNode);
    }

    Stream<? extends Node> parseNode(org.jsoup.nodes.Node html) {
        if (html instanceof TextNode) {
            return TextParser.parseText(this, (TextNode)html);
        }
        if (html instanceof Element) {
            return ElementResolver.resolveParser(html.nodeName()).parse(this, (Element)html);
        }
        return Stream.empty();
    }

    public String toString() {
        return "HtmlParser{keepWhitespace=" + this.keepWhitespace + ", languageCallback=" + (this.languageCallback != IGNORE ? "(set)" : "IGNORE") + ", fallbackReporter=" + (this.fallbackReporter != IGNORE ? "(set)" : "IGNORE") + "}";
    }

    public Doc unmarshall(String html) {
        return HtmlConverter.INSTANCE.unmarshall(this, html);
    }
}

