/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.ex;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.node.Node;
import javax.annotation.Nullable;

public abstract class HtmlException
extends AdfException {
    private static final long serialVersionUID = 1L;

    protected HtmlException(String message) {
        super(message);
    }

    protected HtmlException(String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public static class HtmlStructureException
    extends HtmlException {
        private static final long serialVersionUID = 1L;
        private final String parentType;
        private final Class<?> targetClass;
        private final String childType;

        public HtmlStructureException(String parentType, Class<?> targetClass, Node child) {
            super("Content item in node '" + parentType + "' must be instance of '" + targetClass.getSimpleName() + "' but found node with type '" + child.elementType() + "'");
            this.parentType = parentType;
            this.targetClass = targetClass;
            this.childType = child.elementType();
        }

        public String parentType() {
            return this.parentType;
        }

        public Class<?> targetClass() {
            return this.targetClass;
        }

        public String childType() {
            return this.childType;
        }
    }

    public static class HtmlParseException
    extends HtmlException {
        private static final long serialVersionUID = 1L;

        public HtmlParseException() {
            super("Unable to parse HTML content");
        }

        public HtmlParseException(Throwable cause) {
            super("Unable to parse HTML content", cause);
        }
    }
}

