package com.atlassian.adapter.jackson;

/**
 * Adapter for {@link org.codehaus.jackson.map.ObjectMapper}. Removes checked exceptions.
 *
 * @since v1.0
 */
public class ObjectMapper {

    private final org.codehaus.jackson.map.ObjectMapper mapper;

    public ObjectMapper() {
        mapper = new org.codehaus.jackson.map.ObjectMapper();
    }

    /**
     * @see {@link org.codehaus.jackson.map.ObjectMapper#writeValueAsString(Object)}
     */
    public String writeValueAsString(final Object value) {
        try {
            return mapper.writeValueAsString(value);
        } catch (final Exception e) {
            throw new RuntimeException(e);
        }
    }
}
