/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.osgi;

import com.atlassian.activeobjects.config.ActiveObjectsConfiguration;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.internal.ActiveObjectsFactory;
import com.atlassian.activeobjects.osgi.TenantAwareActiveObjects;
import com.atlassian.activeobjects.plugin.ActiveObjectModuleDescriptor;
import com.atlassian.activeobjects.spi.ContextClassLoaderThreadFactory;
import com.atlassian.activeobjects.spi.HotRestartEvent;
import com.atlassian.activeobjects.spi.InitExecutorServiceProvider;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ActiveObjectsServiceFactory
implements ServiceFactory,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ActiveObjectsServiceFactory.class);
    private static final String INIT_TASK_TIMEOUT_MS_PROPERTY = "ao-plugin.init.task.timeout";
    @VisibleForTesting
    protected static final int INIT_TASK_TIMEOUT_MS = Integer.getInteger("ao-plugin.init.task.timeout", 30000);
    private final EventPublisher eventPublisher;
    private final TenantContext tenantContext;
    @VisibleForTesting
    final ThreadFactory aoContextThreadFactory;
    @VisibleForTesting
    final LoadingCache<Tenant, ExecutorService> initExecutorsByTenant;
    @VisibleForTesting
    volatile boolean destroying = false;
    @VisibleForTesting
    volatile boolean cleaning = false;
    @VisibleForTesting
    final Function<Tenant, ExecutorService> initExecutorFn;
    @VisibleForTesting
    final LoadingCache<BundleRef, TenantAwareActiveObjects> aoDelegatesByBundle;
    @VisibleForTesting
    final Map<Bundle, ActiveObjectsConfiguration> unattachedConfigByBundle = new IdentityHashMap<Bundle, ActiveObjectsConfiguration>();
    private final Lock unattachedConfigsLock = new ReentrantLock();

    public ActiveObjectsServiceFactory(final @Nonnull ActiveObjectsFactory factory, @Nonnull EventPublisher eventPublisher, final @Nonnull TenantContext tenantContext, @Nonnull ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, final @Nonnull InitExecutorServiceProvider initExecutorServiceProvider) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.tenantContext = (TenantContext)Preconditions.checkNotNull((Object)tenantContext);
        Preconditions.checkNotNull((Object)factory);
        Preconditions.checkNotNull((Object)threadLocalDelegateExecutorFactory);
        Preconditions.checkNotNull((Object)initExecutorServiceProvider);
        ClassLoader bundleContextClassLoader = Thread.currentThread().getContextClassLoader();
        this.aoContextThreadFactory = new ContextClassLoaderThreadFactory(bundleContextClassLoader);
        this.initExecutorsByTenant = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Tenant, ExecutorService>(){

            public ExecutorService load(@Nonnull Tenant tenant) throws Exception {
                logger.debug("creating new init executor for {}", (Object)tenant);
                return initExecutorServiceProvider.initExecutorService(tenant);
            }
        });
        this.initExecutorFn = new Function<Tenant, ExecutorService>(){

            @Override
            public ExecutorService apply(@Nullable Tenant tenant) {
                if (ActiveObjectsServiceFactory.this.destroying) {
                    throw new IllegalStateException("applied initExecutorFn after ActiveObjectsServiceFactory destruction");
                }
                if (ActiveObjectsServiceFactory.this.cleaning) {
                    throw new IllegalStateException("applied initExecutorFn during ActiveObjects cleaning");
                }
                Preconditions.checkNotNull((Object)tenant);
                return (ExecutorService)ActiveObjectsServiceFactory.this.initExecutorsByTenant.getUnchecked((Object)tenant);
            }
        };
        this.aoDelegatesByBundle = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BundleRef, TenantAwareActiveObjects>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TenantAwareActiveObjects load(@Nonnull BundleRef bundleRef) throws Exception {
                TenantAwareActiveObjects delegate = new TenantAwareActiveObjects(bundleRef.bundle, factory, tenantContext, ActiveObjectsServiceFactory.this.initExecutorFn);
                delegate.init();
                ActiveObjectsServiceFactory.this.unattachedConfigsLock.lock();
                try {
                    ActiveObjectsConfiguration aoConfig = ActiveObjectsServiceFactory.this.unattachedConfigByBundle.get(bundleRef.bundle);
                    if (aoConfig != null) {
                        delegate.setAoConfiguration(aoConfig);
                        ActiveObjectsServiceFactory.this.unattachedConfigByBundle.remove(bundleRef.bundle);
                    }
                }
                finally {
                    ActiveObjectsServiceFactory.this.unattachedConfigsLock.unlock();
                }
                return delegate;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug("afterPropertiesSet");
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        logger.debug("destroy");
        this.destroying = true;
        for (ExecutorService initExecutor : this.initExecutorsByTenant.asMap().values()) {
            initExecutor.shutdownNow();
        }
        for (TenantAwareActiveObjects aoDelegate : this.aoDelegatesByBundle.asMap().values()) {
            aoDelegate.destroy();
        }
        this.eventPublisher.unregister((Object)this);
    }

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        Preconditions.checkNotNull((Object)bundle);
        logger.debug("getService bundle [{}]", (Object)bundle.getSymbolicName());
        if (this.destroying) {
            throw new IllegalStateException("getService after ActiveObjectsServiceFactory destruction");
        }
        return this.aoDelegatesByBundle.getUnchecked((Object)new BundleRef(bundle));
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object ao) {
        Preconditions.checkNotNull((Object)bundle);
        logger.debug("ungetService bundle [{}]", (Object)bundle.getSymbolicName());
        this.aoDelegatesByBundle.invalidate((Object)new BundleRef(bundle));
        if (ao instanceof TenantAwareActiveObjects) {
            ((TenantAwareActiveObjects)ao).destroy();
        }
    }

    public void startCleaning() {
        logger.debug("startCleaning");
        this.cleaning = true;
        for (ExecutorService initExecutor : this.initExecutorsByTenant.asMap().values()) {
            initExecutor.shutdownNow();
            try {
                if (initExecutor.awaitTermination(INIT_TASK_TIMEOUT_MS, TimeUnit.MILLISECONDS)) continue;
                logger.error("startCleaning timed out after {}ms awaiting init thread completion, continuing; note that this timeout may be adjusted via the system property '{}'", (Object)INIT_TASK_TIMEOUT_MS, (Object)INIT_TASK_TIMEOUT_MS_PROPERTY);
            }
            catch (InterruptedException e) {
                logger.error("startCleaning interrupted while awaiting running init thread completion, continuing", (Throwable)e);
            }
        }
    }

    public void stopCleaning() {
        logger.debug("stopCleaning");
        this.cleaning = false;
    }

    @EventListener
    public void onTenantArrived(TenantArrivedEvent event) {
        Tenant tenant = this.tenantContext.getCurrentTenant();
        logger.debug("onTenantArrived tenant arrived {}", (Object)tenant);
        if (tenant != null) {
            for (TenantAwareActiveObjects aoDelegate : ImmutableList.copyOf(this.aoDelegatesByBundle.asMap().values())) {
                logger.debug("onTenantArrived starting AO delegate for bundle [{}]", (Object)aoDelegate.getBundle().getSymbolicName());
                aoDelegate.startActiveObjects(tenant);
            }
        }
    }

    public Promise<List<ActiveObjects>> doHotRestart() {
        ArrayList<Promise<ActiveObjects>> promises = new ArrayList<Promise<ActiveObjects>>();
        Tenant tenant = this.tenantContext.getCurrentTenant();
        logger.debug("onHotRestart performing hot restart with tenant {}", (Object)tenant);
        if (tenant != null) {
            ExecutorService initExecutor = (ExecutorService)this.initExecutorsByTenant.getIfPresent((Object)tenant);
            this.initExecutorsByTenant.invalidate((Object)tenant);
            for (TenantAwareActiveObjects aoDelegate : ImmutableList.copyOf(this.aoDelegatesByBundle.asMap().values())) {
                String bundleName = aoDelegate.getBundle().getSymbolicName();
                logger.debug("onHotRestart restarting AO delegate for bundle [{}]", (Object)bundleName);
                Promise<ActiveObjects> bundleAOPromise = aoDelegate.restartActiveObjects(tenant);
                if (bundleAOPromise == null) {
                    logger.warn("Cannot get AO promise for a bundle [{}]. Will try to continue the process.", (Object)bundleName);
                    continue;
                }
                promises.add(bundleAOPromise);
            }
            if (initExecutor != null) {
                logger.debug("onHotRestart terminating any initExecutor threads");
                initExecutor.shutdownNow();
            }
        }
        return Promises.when(promises);
    }

    @EventListener
    public void onHotRestart(HotRestartEvent hotRestartEvent) {
        this.doHotRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onPluginModuleEnabledEvent(PluginModuleEnabledEvent pluginModuleEnabledEvent) {
        Bundle bundle;
        Plugin plugin;
        ModuleDescriptor moduleDescriptor = pluginModuleEnabledEvent.getModule();
        if (moduleDescriptor instanceof ActiveObjectModuleDescriptor && (plugin = moduleDescriptor.getPlugin()) instanceof OsgiPlugin && (bundle = ((OsgiPlugin)plugin).getBundle()) != null) {
            boolean attachedToDelegate = false;
            ActiveObjectsConfiguration aoConfig = ((ActiveObjectModuleDescriptor)moduleDescriptor).getConfiguration();
            this.unattachedConfigsLock.lock();
            try {
                for (TenantAwareActiveObjects aoDelegate : this.aoDelegatesByBundle.asMap().values()) {
                    if (!aoDelegate.getBundle().equals(bundle)) continue;
                    logger.debug("onPluginModuleEnabledEvent attaching <ao> configuration module to ActiveObjects service of [{}]", (Object)plugin);
                    aoDelegate.setAoConfiguration(aoConfig);
                    attachedToDelegate = true;
                    break;
                }
                if (!attachedToDelegate) {
                    logger.debug("onPluginModuleEnabledEvent storing unattached <ao> configuration module for [{}]", (Object)plugin);
                    this.unattachedConfigByBundle.put(bundle, aoConfig);
                }
            }
            finally {
                this.unattachedConfigsLock.unlock();
            }
        }
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
        Bundle bundle;
        Plugin plugin = pluginEnabledEvent.getPlugin();
        if (plugin instanceof OsgiPlugin && (bundle = ((OsgiPlugin)plugin).getBundle()) != null && this.unattachedConfigByBundle.containsKey(bundle)) {
            logger.debug("onPluginEnabledEvent attaching unbound <ao> to [{}]", (Object)plugin);
            this.aoDelegatesByBundle.getUnchecked((Object)new BundleRef(bundle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onPluginDisabledEvent(PluginDisabledEvent pluginDisabledEvent) {
        Bundle bundle;
        Plugin plugin = pluginDisabledEvent.getPlugin();
        if (plugin instanceof OsgiPlugin && (bundle = ((OsgiPlugin)plugin).getBundle()) != null) {
            logger.debug("onPluginDisabledEvent removing delegate for [{}]", (Object)plugin);
            this.aoDelegatesByBundle.invalidate((Object)new BundleRef(bundle));
            this.unattachedConfigsLock.lock();
            try {
                if (this.unattachedConfigByBundle.containsKey(bundle)) {
                    logger.debug("onPluginDisabledEvent removing unbound <ao> for [{}]", (Object)plugin);
                    this.unattachedConfigByBundle.remove(bundle);
                }
            }
            finally {
                this.unattachedConfigsLock.unlock();
            }
        }
    }

    protected static class BundleRef {
        final Bundle bundle;

        public BundleRef(Bundle bundle) {
            this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BundleRef bundleRef = (BundleRef)o;
            return this.bundle == bundleRef.bundle;
        }

        public int hashCode() {
            return System.identityHashCode(this.bundle);
        }
    }
}

