/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionUnwrapper {
    private static final Logger log = LoggerFactory.getLogger(ConnectionUnwrapper.class);

    private ConnectionUnwrapper() {
    }

    @Nonnull
    public static Optional<Connection> tryUnwrapConnection(@Nonnull Connection origin) {
        try {
            Connection withoutProxies = origin.getMetaData().getConnection();
            if (withoutProxies.getClass().getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                try {
                    Field inner = withoutProxies.getClass().getDeclaredField("inner");
                    inner.setAccessible(true);
                    return Optional.ofNullable((Connection)inner.get(withoutProxies));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.warn("Wasn't able to unwrap NewProxyConnection", (Throwable)e);
                    return Optional.of(withoutProxies);
                }
            }
            return Optional.of(withoutProxies);
        }
        catch (SQLException e) {
            log.warn("Couldn't unwrap the connection {}", (Object)origin, (Object)e);
            return Optional.empty();
        }
    }
}

