/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import com.atlassian.activeobjects.ao.ConverterUtils;
import com.atlassian.activeobjects.internal.DatabaseProviderFactory;
import com.atlassian.activeobjects.internal.DatabaseProviderNotFoundException;
import com.atlassian.activeobjects.internal.DriverNameExtractor;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.google.common.base.Preconditions;
import javax.sql.DataSource;
import net.java.ao.DatabaseProvider;
import net.java.ao.Disposable;
import net.java.ao.DisposableDataSource;
import net.java.ao.builder.DelegatingDisposableDataSourceHandler;
import net.java.ao.db.ClientDerbyDatabaseProvider;
import net.java.ao.db.EmbeddedDerbyDatabaseProvider;
import net.java.ao.db.H2DatabaseProvider;
import net.java.ao.db.HSQLDatabaseProvider;
import net.java.ao.db.MySQLDatabaseProvider;
import net.java.ao.db.NuoDBDatabaseProvider;
import net.java.ao.db.NuoDBDisposableDataSourceHandler;
import net.java.ao.db.OracleDatabaseProvider;
import net.java.ao.db.PostgreSQLDatabaseProvider;
import net.java.ao.db.SQLServerDatabaseProvider;

public final class JdbcDriverDatabaseProviderFactory
implements DatabaseProviderFactory {
    private final DriverNameExtractor driverNameExtractor;

    public JdbcDriverDatabaseProviderFactory(DriverNameExtractor driverNameExtractor) {
        this.driverNameExtractor = (DriverNameExtractor)Preconditions.checkNotNull((Object)driverNameExtractor);
    }

    @Override
    public DatabaseProvider getDatabaseProvider(DataSource dataSource, DatabaseType databaseType, String schema) {
        for (DatabaseProviderFactoryEnum dbProviderFactory : DatabaseProviderFactoryEnum.values()) {
            if (!dbProviderFactory.accept(databaseType)) continue;
            return dbProviderFactory.getDatabaseProvider(dataSource, schema);
        }
        String driverName = this.getDriverName(dataSource);
        for (DatabaseProviderFactoryEnum dbProviderFactory : DatabaseProviderFactoryEnum.values()) {
            if (!dbProviderFactory.accept(driverName)) continue;
            return dbProviderFactory.getDatabaseProvider(dataSource, schema);
        }
        throw new DatabaseProviderNotFoundException(driverName);
    }

    private String getDriverName(DataSource dataSource) {
        return this.driverNameExtractor.getDriverName(dataSource);
    }

    private static DisposableDataSource getDisposableDataSource(DataSource dataSource) {
        return DelegatingDisposableDataSourceHandler.newInstance(dataSource, new Disposable(){

            @Override
            public void dispose() {
            }
        });
    }

    private static enum DatabaseProviderFactoryEnum {
        MYSQL(DatabaseType.MYSQL, "mysql"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new MySQLDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource));
            }
        }
        ,
        DERBY_NETWORK(DatabaseType.DERBY_NETWORK, "derby"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new ClientDerbyDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource));
            }
        }
        ,
        DERBY_EMBEDDED(DatabaseType.DERBY_EMBEDDED, "derby"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new EmbeddedDerbyDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), "a-fake-uri");
            }
        }
        ,
        ORACLE(DatabaseType.ORACLE, "oracle"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new OracleDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        POSTGRESQL(DatabaseType.POSTGRESQL, "postgres"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new PostgreSQLDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        MSSQL(DatabaseType.MS_SQL, "sqlserver"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new SQLServerDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        MSSQL_JTDS(DatabaseType.MS_SQL, "jtds"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new SQLServerDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        HSQLDB(DatabaseType.HSQL, "hsql"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new HSQLDatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        H2(DatabaseType.H2, "h2"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new H2DatabaseProvider(JdbcDriverDatabaseProviderFactory.getDisposableDataSource(dataSource), schema);
            }
        }
        ,
        NUODB(DatabaseType.NUODB, "nuodb"){

            @Override
            public DatabaseProvider getDatabaseProvider(DataSource dataSource, String schema) {
                return new NuoDBDatabaseProvider(NuoDBDisposableDataSourceHandler.newInstance(dataSource), schema);
            }
        };

        private final DatabaseType databaseType;
        private final String driverName;

        private DatabaseProviderFactoryEnum(DatabaseType databaseType, String driverName) {
            this.databaseType = (DatabaseType)Preconditions.checkNotNull((Object)databaseType);
            this.driverName = (String)Preconditions.checkNotNull((Object)driverName);
        }

        boolean accept(DatabaseType otherDatabaseType) {
            return this.databaseType.equals((Object)otherDatabaseType);
        }

        boolean accept(String otherDriverName) {
            return otherDriverName != null && ConverterUtils.toLowerCase(otherDriverName).contains(this.driverName);
        }

        public abstract DatabaseProvider getDatabaseProvider(DataSource var1, String var2);
    }
}

