/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.internal.ActiveObjectsSqlException;
import com.atlassian.activeobjects.internal.TransactionManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.DefaultPolymorphicTypeMapper;
import net.java.ao.EntityManager;
import net.java.ao.EntityStreamCallback;
import net.java.ao.PolymorphicTypeMapper;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class EntityManagedActiveObjects
implements ActiveObjects {
    private final EntityManager entityManager;
    private final TransactionManager transactionManager;

    protected EntityManagedActiveObjects(EntityManager entityManager, TransactionManager transactionManager) {
        this.entityManager = (EntityManager)Preconditions.checkNotNull((Object)entityManager);
        this.transactionManager = (TransactionManager)Preconditions.checkNotNull((Object)transactionManager);
    }

    @Override
    public final void migrate(Class<? extends RawEntity<?>> ... entities) {
        try {
            this.entityManager.setPolymorphicTypeMapper((PolymorphicTypeMapper)new DefaultPolymorphicTypeMapper((Class[])entities));
            this.entityManager.migrate((Class[])entities);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final void flushAll() {
        this.entityManager.flushAll();
    }

    @Override
    public final void flush(RawEntity<?> ... entities) {
        this.entityManager.flush(entities);
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] get(Class<T> type, K ... keys) {
        try {
            return this.entityManager.get(type, (Object[])keys);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T get(Class<T> type, K key) {
        try {
            return (T)this.entityManager.get(type, key);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) {
        try {
            return (T)this.entityManager.create(type, params);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) {
        try {
            return (T)this.entityManager.create(type, params);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final void delete(RawEntity<?> ... entities) {
        try {
            this.entityManager.delete(entities);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] find(Class<T> type) {
        try {
            return this.entityManager.find(type);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) {
        try {
            return this.entityManager.find(type, criteria, parameters);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) {
        try {
            return this.entityManager.find(type, query);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) {
        try {
            return this.entityManager.find(type, field, query);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) {
        try {
            return this.entityManager.findWithSQL(type, keyField, sql, parameters);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> void stream(Class<T> type, Query query, EntityStreamCallback<T, K> streamCallback) {
        try {
            this.entityManager.stream(type, query, streamCallback);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T extends RawEntity<K>, K> void stream(Class<T> type, EntityStreamCallback<T, K> streamCallback) {
        try {
            this.entityManager.stream(type, streamCallback);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <K> int count(Class<? extends RawEntity<K>> type) {
        try {
            return this.entityManager.count(type);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) {
        try {
            return this.entityManager.count(type, criteria, parameters);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <K> int count(Class<? extends RawEntity<K>> type, Query query) {
        try {
            return this.entityManager.count(type, query);
        }
        catch (SQLException e) {
            throw new ActiveObjectsSqlException(this.entityManager, e);
        }
    }

    @Override
    public final <T> T executeInTransaction(TransactionCallback<T> callback) {
        return this.transactionManager.doInTransaction(callback);
    }
}

