/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.confluence.hibernate;

import com.atlassian.activeobjects.confluence.hibernate.DialectExtractor;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;

public final class HibernateSessionDialectExtractor
implements DialectExtractor {
    private final PluginHibernateSessionFactory sessionFactory;
    private final TransactionTemplate transactionTemplate;

    public HibernateSessionDialectExtractor(PluginHibernateSessionFactory sessionFactory, TransactionTemplate transactionTemplate) {
        this.sessionFactory = (PluginHibernateSessionFactory)Preconditions.checkNotNull((Object)sessionFactory);
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate);
    }

    @Override
    public Class<? extends Dialect> getDialect() {
        return (Class)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Class<? extends Dialect>>(){

            public Class<? extends Dialect> doInTransaction() {
                SessionFactory hibernateSessionFactory = HibernateSessionDialectExtractor.this.sessionFactory.getSession().getSessionFactory();
                if (hibernateSessionFactory instanceof SessionFactoryImplementor) {
                    return ((SessionFactoryImplementor)hibernateSessionFactory).getDialect().getClass();
                }
                return null;
            }
        });
    }
}

