/*
 * Decompiled with CFR 0.152.
 */
package com.assistne.icondottextview;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import com.assistne.icondottextview.Config;
import com.assistne.icondottextview.IconDotTextView;
import com.assistne.icondottextview.R;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;

public class TextConfig
implements Config {
    private static final String TAG = "#TextConfig";
    private static int DEFAULT_SIZE;
    @ColorInt
    private static final int DEFAULT_COLOR;
    private static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    private int mSize;
    private int mMaxWidth = Integer.MAX_VALUE;
    private ColorStateList mColorStateList;
    private String mText;
    private TextPaint mTextPaint;
    private Layout mLayout;

    public TextConfig(TypedArray typedArray) {
        DEFAULT_SIZE = IconDotTextView.sDefaultTextSize;
        if (typedArray != null) {
            this.mSize = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_textSize, DEFAULT_SIZE);
            this.mColorStateList = typedArray.getColorStateList(R.styleable.IconDotTextView_textColor);
            if (this.mColorStateList == null) {
                this.mColorStateList = ColorStateList.valueOf((int)DEFAULT_COLOR);
            }
            this.mText = typedArray.getString(R.styleable.IconDotTextView_text);
        }
        this.init();
    }

    public TextConfig(String text, int size, @ColorInt int color) {
        this.mText = text;
        this.mSize = size;
        this.mColorStateList = ColorStateList.valueOf((int)color);
        this.init();
    }

    private void init() {
        this.initPaint();
        this.initLayout();
    }

    private void initPaint() {
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.setColor(DEFAULT_COLOR);
        this.mTextPaint.setTextSize((float)this.mSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initLayout() {
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            TextPaint paint = this.mTextPaint;
            String source = this.mText;
            boolean start = false;
            int end = this.mText.length();
            Layout.Alignment alignment = Layout.Alignment.ALIGN_CENTER;
            float spacingAdd = 0.0f;
            float spacingMult = 1.0f;
            boolean includePad = true;
            TextUtils.TruncateAt truncateAt = TextUtils.TruncateAt.END;
            int outerWidth = this.getWidth();
            if (this.getDesiredWidth() <= outerWidth) {
                this.mLayout = new StaticLayout((CharSequence)source, 0, end, paint, outerWidth, alignment, 1.0f, 0.0f, true, truncateAt, outerWidth);
                return;
            } else if (Build.VERSION.SDK_INT >= 23) {
                StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)source, (int)0, (int)end, (TextPaint)paint, (int)outerWidth).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(true).setMaxLines(1).setEllipsize(truncateAt);
                this.mLayout = builder.build();
                return;
            } else {
                try {
                    Constructor<?>[] constructorArr = StaticLayout.class.getConstructors();
                    Constructor<?> constructor = null;
                    if (constructorArr != null && constructorArr.length != 0) {
                        for (Constructor<?> cons : constructorArr) {
                            Class<?>[] params = cons.getParameterTypes();
                            if (params == null || params.length != 13) continue;
                            constructor = cons;
                            break;
                        }
                    }
                    if (constructor == null) return;
                    constructor.setAccessible(true);
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.mLayout = (Layout)constructor.newInstance(source, 0, end, paint, outerWidth, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, Float.valueOf(1.0f), Float.valueOf(0.0f), true, truncateAt, outerWidth, 1);
                        return;
                    }
                    Class<?> clazzTextDirectionHeuristics = Class.forName("android.text.TextDirectionHeuristics");
                    Field fieldLTR = clazzTextDirectionHeuristics.getField("FIRSTSTRONG_LTR");
                    fieldLTR.setAccessible(true);
                    this.mLayout = (Layout)constructor.newInstance(source, 0, end, paint, outerWidth, alignment, fieldLTR.get(null), Float.valueOf(1.0f), Float.valueOf(0.0f), true, truncateAt, outerWidth, 1);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    if (this.mLayout == null) {
                        this.mLayout = new StaticLayout((CharSequence)source, 0, end, paint, outerWidth, alignment, 1.0f, 0.0f, true, truncateAt, outerWidth);
                    }
                }
            }
        } else {
            this.mLayout = null;
        }
    }

    @Override
    public int getWidth() {
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            int desiredWidth = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mText, (TextPaint)this.mTextPaint));
            return Math.min(desiredWidth, this.mMaxWidth);
        }
        return 0;
    }

    @Override
    public int getDesiredHeight() {
        return this.mLayout == null ? 0 : this.mLayout.getHeight();
    }

    @Override
    public int getDesiredWidth() {
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            return (int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mText, (TextPaint)this.mTextPaint));
        }
        return 0;
    }

    @Override
    public int getHeight() {
        return this.mLayout == null ? 0 : this.mLayout.getHeight();
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.mLayout != null) {
            this.mTextPaint.setColor(this.mColorStateList.getColorForState(this.mTextPaint.drawableState, DEFAULT_COLOR));
            this.mLayout.draw(canvas);
        }
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
        this.mLayout = null;
        this.initLayout();
    }

    @Override
    public void setMaxHeight(int maxHeight) {
    }

    @Override
    public boolean setState(int[] state) {
        int[] oldState = this.mTextPaint.drawableState;
        if (!Arrays.equals(oldState, state) && this.mColorStateList.getColorForState(state, DEFAULT_COLOR) != this.mColorStateList.getColorForState(oldState, DEFAULT_COLOR)) {
            this.mTextPaint.drawableState = state;
            return true;
        }
        return false;
    }

    public void setColor(@ColorInt int color) {
        this.mColorStateList = ColorStateList.valueOf((int)color);
    }

    public void setText(String text) {
        this.mText = text;
        this.mLayout = null;
        this.initLayout();
    }

    public String getText() {
        return this.mText;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
        this.mTextPaint.setTextSize((float)size);
    }

    static {
        DEFAULT_COLOR = Color.argb((int)137, (int)0, (int)0, (int)0);
    }
}

