/*
 * Decompiled with CFR 0.152.
 */
package com.assistne.icondottextview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.assistne.icondottextview.DotConfig;
import com.assistne.icondottextview.IconConfig;
import com.assistne.icondottextview.R;
import com.assistne.icondottextview.TextConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IconDotTextView
extends View {
    private static final String TAG = "#IconDotTextView";
    private static final int ALIGN_TOP = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final int ALIGN_BOTTOM = 4;
    private static final int ALIGN_LEFT = 8;
    private static final int DEFAULT_SPACING = 0;
    public static final int ROW = 1;
    public static final int ROW_REVERSE = 2;
    public static final int COLUMN = 4;
    public static final int COLUMN_REVERSE = 8;
    public static final int POSITION_LEFT_TOP = 0;
    public static final int POSITION_LEFT_BOTTOM = 1;
    public static final int POSITION_RIGHT_TOP = 2;
    public static final int POSITION_RIGHT_BOTTOM = 3;
    private static final int DEFAULT_DOT_POSITION = 2;
    private static final int DEFAULT_DOT_MARGIN = -15;
    int mDotPosition = 2;
    private int mDotMarginTop;
    private int mDotMarginRight;
    private int mDotMarginBottom;
    private int mDotMarginLeft;
    private int mSpacing;
    private int mDirection;
    private boolean mDotAlignToIcon;
    private int mIconLeft;
    private int mIconTop;
    private boolean mIsDotVisible;
    private DotConfig mDotConfig;
    private IconConfig mIconConfig;
    private TextConfig mTextConfig;
    static int sDefaultIconSize;
    static int sDefaultDotSize;
    static int sDefaultDotTextSize;
    static int sDefaultTextSize;

    public IconDotTextView(Context context) {
        this(context, null);
    }

    public IconDotTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconDotTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int direction;
        Resources resources = context.getResources();
        sDefaultIconSize = resources.getDimensionPixelSize(R.dimen.default_icon_size);
        sDefaultDotSize = resources.getDimensionPixelSize(R.dimen.default_dot_size);
        sDefaultDotTextSize = resources.getDimensionPixelSize(R.dimen.default_dot_text_size);
        sDefaultTextSize = resources.getDimensionPixelSize(R.dimen.default_text_size);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IconDotTextView);
        this.mSpacing = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_spacing, 0);
        this.mDirection = direction = typedArray.getInt(R.styleable.IconDotTextView_direction, 4);
        this.mDotPosition = this.getPositionFromArray(typedArray);
        this.mDotAlignToIcon = typedArray.getBoolean(R.styleable.IconDotTextView_dot_alignToIcon, true);
        this.mDotMarginTop = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_marginTop, -15);
        this.mDotMarginRight = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_marginRight, -15);
        this.mDotMarginBottom = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_marginBottom, -15);
        this.mDotMarginLeft = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_marginLeft, -15);
        this.mIsDotVisible = typedArray.getBoolean(R.styleable.IconDotTextView_dot_visible, false);
        this.mDotConfig = new DotConfig(typedArray);
        this.mIconConfig = new IconConfig(context, typedArray);
        this.mTextConfig = new TextConfig(typedArray);
        typedArray.recycle();
    }

    private int getPositionFromArray(TypedArray typedArray) {
        int alignInfo = typedArray.getInt(R.styleable.IconDotTextView_dot_alignTo, 3);
        if ((alignInfo & 1) != 0) {
            if ((alignInfo & 2) != 0) {
                return 2;
            }
            return 0;
        }
        if ((alignInfo & 2) != 0) {
            return 3;
        }
        return 1;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int maxContentWidth;
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int contentWidth = maxContentWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int res = width;
        int iconDesiredWidth = this.mIconConfig.getDesiredWidth();
        int textDesiredWidth = this.mTextConfig.getDesiredWidth();
        if (this.mDirection == 1 || this.mDirection == 2) {
            int desiredWidth = iconDesiredWidth + textDesiredWidth + this.mSpacing;
            switch (mode) {
                case -2147483648: {
                    this.mIconConfig.setMaxWidth(maxContentWidth - textDesiredWidth);
                    contentWidth = Math.min(maxContentWidth, desiredWidth);
                    break;
                }
                case 0x40000000: {
                    this.mIconConfig.setMaxWidth(maxContentWidth - textDesiredWidth);
                    contentWidth = maxContentWidth;
                    break;
                }
                case 0: {
                    contentWidth = desiredWidth;
                }
            }
            res = contentWidth + this.getPaddingLeft() + this.getPaddingRight();
        } else if (this.mDirection == 4 || this.mDirection == 8) {
            int delta;
            int desiredWidth = Math.max(iconDesiredWidth, textDesiredWidth);
            switch (mode) {
                case -2147483648: {
                    this.mTextConfig.setMaxWidth(maxContentWidth);
                    this.mIconConfig.setMaxWidth(maxContentWidth);
                    contentWidth = Math.min(desiredWidth, maxContentWidth);
                    break;
                }
                case 0x40000000: {
                    this.mTextConfig.setMaxWidth(maxContentWidth);
                    this.mIconConfig.setMaxWidth(maxContentWidth);
                    contentWidth = maxContentWidth;
                    break;
                }
                case 0: {
                    contentWidth = desiredWidth;
                }
            }
            res = contentWidth + this.getPaddingLeft() + this.getPaddingRight();
            if (this.mDotAlignToIcon && (delta = res / 2 - (this.mDotConfig.getWidth() + this.getDotHorizontalMargin() + this.mIconConfig.getWidth() / 2)) < 0) {
                res -= delta * 2;
            }
        }
        return Math.max(this.getSuggestedMinimumWidth(), res);
    }

    private int measureHeight(int heightMeasureSpec) {
        int maxContentHeight;
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int contentHeight = maxContentHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        int res = height;
        int iconDesiredHeight = this.mIconConfig.getDesiredHeight();
        int textDesiredHeight = this.mTextConfig.getDesiredHeight();
        if (this.mDirection == 1 || this.mDirection == 2) {
            int desiredHeight = Math.max(iconDesiredHeight, textDesiredHeight);
            switch (mode) {
                case -2147483648: {
                    this.mIconConfig.setMaxHeight(maxContentHeight);
                    contentHeight = Math.min(desiredHeight, maxContentHeight);
                    break;
                }
                case 0x40000000: {
                    this.mTextConfig.setMaxHeight(maxContentHeight);
                    this.mIconConfig.setMaxHeight(maxContentHeight);
                    contentHeight = maxContentHeight;
                    break;
                }
                case 0: {
                    contentHeight = desiredHeight;
                }
            }
            res = contentHeight + this.getPaddingTop() + this.getPaddingRight();
        } else if (this.mDirection == 4 || this.mDirection == 8) {
            int delta;
            int desiredHeight = iconDesiredHeight + textDesiredHeight + this.mSpacing;
            switch (mode) {
                case -2147483648: {
                    this.mIconConfig.setMaxHeight(maxContentHeight - textDesiredHeight);
                    contentHeight = Math.min(maxContentHeight, desiredHeight);
                    break;
                }
                case 0x40000000: {
                    this.mIconConfig.setMaxHeight(maxContentHeight - textDesiredHeight);
                    contentHeight = maxContentHeight;
                    break;
                }
                case 0: {
                    contentHeight = desiredHeight;
                }
            }
            res = contentHeight + this.getPaddingTop() + this.getPaddingBottom();
            if (this.mDotAlignToIcon && this.getDotVerticalMargin() < 0 && (delta = this.getPaddingTop() + this.getDotVerticalMargin()) < 0) {
                res -= delta * 2;
            }
        }
        return Math.max(this.getSuggestedMinimumHeight(), res);
    }

    private int getDotHorizontalMargin() {
        switch (this.mDotPosition) {
            case 0: 
            case 1: {
                return this.mDotAlignToIcon ? this.mDotMarginRight : this.mDotMarginLeft;
            }
            case 2: 
            case 3: {
                return !this.mDotAlignToIcon ? this.mDotMarginRight : this.mDotMarginLeft;
            }
        }
        return 0;
    }

    private int getDotVerticalMargin() {
        switch (this.mDotPosition) {
            case 0: 
            case 2: {
                return this.mDotMarginTop;
            }
            case 1: 
            case 3: {
                return this.mDotMarginBottom;
            }
        }
        return 0;
    }

    protected void onDraw(Canvas canvas) {
        this.drawIcon(canvas);
        this.drawText(canvas);
        if (this.mIsDotVisible) {
            this.drawDot(canvas);
        }
    }

    private void drawIcon(Canvas canvas) {
        int contentHeight = this.mIconConfig.getHeight() + this.mSpacing + this.mTextConfig.getHeight();
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int tLeft = 0;
        int tTop = 0;
        switch (this.mDirection) {
            case 1: {
                tTop = (height - this.mIconConfig.getHeight()) / 2 + this.getPaddingTop();
                tLeft = (width - this.mIconConfig.getWidth() - this.mSpacing - this.mTextConfig.getWidth()) / 2 + this.getPaddingLeft();
                break;
            }
            case 2: {
                tTop = (height - this.mIconConfig.getHeight()) / 2 + this.getPaddingTop();
                tLeft = this.getMeasuredWidth() - (width - this.mIconConfig.getWidth() - this.mSpacing - this.mTextConfig.getWidth()) / 2 - this.mIconConfig.getWidth() - this.getPaddingRight();
                break;
            }
            case 4: {
                tTop = (height - contentHeight) / 2 + this.getPaddingTop();
                tLeft = (width - this.mIconConfig.getWidth()) / 2 + this.getPaddingLeft();
                break;
            }
            case 8: {
                tTop = (height - contentHeight) / 2 + this.getPaddingTop() + this.mTextConfig.getHeight() + this.mSpacing;
                tLeft = (width - this.mIconConfig.getWidth()) / 2 + this.getPaddingLeft();
            }
        }
        this.mIconLeft = tLeft;
        this.mIconTop = tTop;
        canvas.save();
        canvas.translate((float)tLeft, (float)tTop);
        this.mIconConfig.draw(canvas);
        canvas.restore();
    }

    private void drawText(Canvas canvas) {
        this.mTextConfig.setState(this.getDrawableState());
        int contentHeight = this.mIconConfig.getHeight() + this.mSpacing + this.mTextConfig.getHeight();
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int tLeft = 0;
        int tTop = 0;
        switch (this.mDirection) {
            case 1: {
                tTop = (height - this.mTextConfig.getHeight()) / 2 + this.getPaddingTop();
                tLeft = this.getMeasuredWidth() - (width - this.mIconConfig.getWidth() - this.mSpacing - this.mTextConfig.getWidth()) / 2 - this.mTextConfig.getWidth() - this.getPaddingLeft();
                break;
            }
            case 2: {
                tTop = (height - this.mTextConfig.getHeight()) / 2 + this.getPaddingTop();
                tLeft = (width - this.mIconConfig.getWidth() - this.mSpacing - this.mTextConfig.getWidth()) / 2 + this.getPaddingLeft();
                break;
            }
            case 4: {
                tTop = (height - contentHeight) / 2 + this.getPaddingTop() + this.mIconConfig.getHeight() + this.mSpacing;
                tLeft = (width - this.mTextConfig.getWidth()) / 2 + this.getPaddingLeft();
                break;
            }
            case 8: {
                tTop = (height - contentHeight) / 2 + this.getPaddingTop();
                tLeft = (width - this.mTextConfig.getWidth()) / 2 + this.getPaddingLeft();
            }
        }
        canvas.save();
        canvas.translate((float)tLeft, (float)tTop);
        this.mTextConfig.draw(canvas);
        canvas.restore();
    }

    private void drawDot(Canvas canvas) {
        int tLeft = 0;
        int tTop = 0;
        if (this.mDotAlignToIcon) {
            switch (this.mDotPosition) {
                case 0: {
                    tLeft = this.mIconLeft - this.mDotMarginRight - this.mDotConfig.getWidth();
                    tTop = this.mIconTop + this.mDotMarginTop;
                    break;
                }
                case 2: {
                    tLeft = this.mIconLeft + this.mIconConfig.getWidth() + this.mDotMarginLeft;
                    tTop = this.mIconTop + this.mDotMarginTop;
                    break;
                }
                case 1: {
                    tLeft = this.mIconLeft - this.mDotMarginRight - this.mDotConfig.getWidth();
                    tTop = this.mIconTop + this.mIconConfig.getHeight() - this.mDotConfig.getHeight() - this.mDotMarginBottom;
                    break;
                }
                case 3: {
                    tLeft = this.mIconLeft + this.mIconConfig.getWidth() + this.mDotMarginLeft;
                    tTop = this.mIconTop + this.mIconConfig.getHeight() - this.mDotConfig.getHeight() - this.mDotMarginBottom;
                }
            }
        } else {
            switch (this.mDotPosition) {
                case 0: {
                    tLeft = this.getPaddingLeft() + Math.max(0, this.mDotMarginLeft);
                    tTop = this.getPaddingTop() + Math.max(0, this.mDotMarginTop);
                    break;
                }
                case 2: {
                    tLeft = this.getWidth() - this.getPaddingRight() - Math.max(0, this.mDotMarginRight) - this.mDotConfig.getWidth();
                    tTop = this.getPaddingTop() + Math.max(0, this.mDotMarginTop);
                    break;
                }
                case 1: {
                    tLeft = this.getPaddingLeft() + Math.max(0, this.mDotMarginLeft);
                    tTop = this.getHeight() - this.getPaddingBottom() - Math.max(0, this.mDotMarginBottom) - this.mDotConfig.getHeight();
                    break;
                }
                case 3: {
                    tLeft = this.getWidth() - this.getPaddingRight() - Math.max(0, this.mDotMarginRight) - this.mDotConfig.getWidth();
                    tTop = this.getHeight() - this.getPaddingBottom() - Math.max(0, this.mDotMarginBottom) - this.mDotConfig.getHeight();
                }
            }
        }
        canvas.save();
        canvas.translate((float)tLeft, (float)tTop);
        this.mDotConfig.draw(canvas);
        canvas.restore();
    }

    protected void drawableStateChanged() {
        int[] state = this.getDrawableState();
        boolean changed = this.mIconConfig.setState(state);
        changed |= this.mTextConfig.setState(state);
        super.drawableStateChanged();
        if (changed |= this.mDotConfig.setState(state)) {
            this.invalidate();
        }
    }

    public void setText(@StringRes int res) throws Resources.NotFoundException {
        this.setText(this.getContext().getResources().getString(res));
    }

    public void setText(@Nullable CharSequence text) {
        String oldText = this.mTextConfig.getText();
        if (TextUtils.isEmpty((CharSequence)text) && !TextUtils.isEmpty((CharSequence)oldText) || !TextUtils.isEmpty((CharSequence)text) && !text.equals(this.mTextConfig.getText())) {
            int oldDesiredWidth = this.mTextConfig.getDesiredWidth();
            this.mTextConfig.setText(TextUtils.isEmpty((CharSequence)text) ? null : text.toString());
            if (oldDesiredWidth != this.mTextConfig.getDesiredWidth()) {
                this.requestLayout();
            } else {
                this.invalidate();
            }
        }
    }

    public void setTextColor(@ColorRes int colorRes) {
        this.mTextConfig.setColor(this.getContext().getResources().getColor(colorRes));
        this.invalidate();
    }

    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        int newSize = (int)this.getRawTextSize(unit, size);
        if (this.mTextConfig.getSize() != newSize) {
            this.mTextConfig.setSize(newSize);
            this.requestLayout();
        }
    }

    private float getRawTextSize(int unit, float size) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        return TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public void setIcon(@DrawableRes int drawableRes) throws Resources.NotFoundException {
        if (this.getContext() != null) {
            this.setIcon(this.getContext().getResources().getDrawable(drawableRes));
        }
    }

    public void setIcon(@Nullable Drawable drawable) {
        if (drawable == null && this.mIconConfig.icon == null || drawable != null && !drawable.equals(this.mIconConfig.icon)) {
            this.mIconConfig.icon = drawable;
            this.invalidate();
        }
    }

    public void setIconSize(int width, int height) {
        boolean needRefresh = false;
        if (this.mIconConfig.width != width) {
            this.mIconConfig.width = width;
            needRefresh = true;
        }
        if (this.mIconConfig.height != height) {
            this.mIconConfig.height = height;
            needRefresh = true;
        }
        if (needRefresh) {
            this.requestLayout();
        }
    }

    public void setDirection(int direction) {
        if (this.mDirection != direction) {
            this.mDirection = direction;
            this.requestLayout();
        }
    }

    public void setDotPosition(int dotPosition) {
        if (this.mDotPosition != dotPosition) {
            this.mDotPosition = dotPosition;
            this.invalidate();
        }
    }

    public void setDotAlignToIcon(boolean alignToIcon) {
        if (this.mDotAlignToIcon != alignToIcon) {
            this.mDotAlignToIcon = alignToIcon;
            this.invalidate();
        }
    }

    public void setSpacing(int spacing) {
        if (this.mSpacing != spacing) {
            this.mSpacing = spacing;
            this.requestLayout();
        }
    }

    public void setDotMargin(int left, int top, int right, int bottom) {
        boolean needRefresh = false;
        if (this.mDotMarginLeft != left) {
            this.mDotMarginLeft = left;
            needRefresh = true;
        }
        if (this.mDotMarginTop != top) {
            this.mDotMarginTop = top;
            needRefresh = true;
        }
        if (this.mDotMarginRight != right) {
            this.mDotMarginRight = right;
            needRefresh = true;
        }
        if (this.mDotMarginBottom != bottom) {
            this.mDotMarginBottom = bottom;
            needRefresh = true;
        }
        if (needRefresh) {
            this.invalidate();
        }
    }

    public void setDotSize(int size) {
        if (this.mDotConfig.getSize() != size) {
            this.mDotConfig.setSize(size);
            this.invalidate();
        }
    }

    public void setDotColor(@ColorInt int color) {
        this.mDotConfig.setColor(color);
        this.invalidate();
    }

    public void setDotText(int number) {
        this.setDotText(String.valueOf(number));
    }

    public void setDotText(CharSequence text) {
        if (this.mDotConfig.textConfig != null) {
            this.mDotConfig.textConfig.setText(text == null ? null : text.toString());
            this.invalidate();
        }
    }

    public void setDotVisibility(boolean visible) {
        if (this.mIsDotVisible != visible) {
            this.mIsDotVisible = visible;
            this.invalidate();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DotPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

