/*
 * Decompiled with CFR 0.152.
 */
package com.assistne.icondottextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.assistne.icondottextview.Config;
import com.assistne.icondottextview.IconDotTextView;
import com.assistne.icondottextview.R;

public class IconConfig
implements Config {
    private static final String TAG = "#IconConfig";
    private static int DEFAULT_SIZE;
    private int size;
    int width;
    int height;
    @Nullable
    Drawable icon;
    private int maxWidth = Integer.MAX_VALUE;
    private int maxHeight = Integer.MAX_VALUE;

    public IconConfig(@NonNull Context context, TypedArray typedArray) {
        DEFAULT_SIZE = IconDotTextView.sDefaultIconSize;
        if (typedArray != null) {
            int res;
            this.width = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_icon_width, DEFAULT_SIZE);
            this.height = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_icon_height, DEFAULT_SIZE);
            if (!this.hasSpecifyWidthAndHeight()) {
                this.size = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_icon_size, DEFAULT_SIZE);
            }
            if ((res = typedArray.getResourceId(R.styleable.IconDotTextView_icon, -1)) != -1) {
                this.icon = Build.VERSION.SDK_INT >= 21 ? context.getDrawable(res) : context.getResources().getDrawable(res);
            }
        }
    }

    private boolean hasSpecifyWidthAndHeight() {
        return this.width != DEFAULT_SIZE || this.height != DEFAULT_SIZE;
    }

    @Override
    public int getWidth() {
        return Math.min(this.maxWidth, this.getDesiredWidth());
    }

    @Override
    public int getHeight() {
        return Math.min(this.maxHeight, this.getDesiredHeight());
    }

    @Override
    public int getDesiredWidth() {
        if (this.icon != null) {
            if (this.width != DEFAULT_SIZE) {
                return this.width;
            }
            if (this.size != DEFAULT_SIZE) {
                return this.size;
            }
            if (this.icon.getIntrinsicWidth() != -1) {
                return this.icon.getIntrinsicWidth();
            }
            return DEFAULT_SIZE;
        }
        return 0;
    }

    @Override
    public int getDesiredHeight() {
        if (this.icon != null) {
            if (this.height != DEFAULT_SIZE) {
                return this.height;
            }
            if (this.size != DEFAULT_SIZE) {
                return this.size;
            }
            if (this.icon.getIntrinsicHeight() != -1) {
                return this.icon.getIntrinsicHeight();
            }
            return DEFAULT_SIZE;
        }
        return 0;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean setState(int[] state) {
        return this.icon != null && this.icon.setState(state);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.icon != null) {
            this.icon.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.icon.draw(canvas);
        }
    }
}

