/*
 * Decompiled with CFR 0.152.
 */
package com.assistne.icondottextview;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.assistne.icondottextview.Config;
import com.assistne.icondottextview.IconDotTextView;
import com.assistne.icondottextview.R;
import com.assistne.icondottextview.TextConfig;

public class DotConfig
implements Config {
    private static int DEFAULT_SIZE;
    @ColorInt
    private static final int DEFAULT_COLOR;
    private static int DEFAULT_TEXT_SIZE;
    @ColorInt
    private static final int DEFAULT_TEXT_COLOR = -1;
    private int mSize;
    @ColorInt
    private int mColor;
    @Nullable
    TextConfig textConfig;
    private Paint mPaint;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxHeight = Integer.MAX_VALUE;

    public DotConfig(TypedArray typedArray) {
        DEFAULT_SIZE = IconDotTextView.sDefaultDotSize;
        DEFAULT_TEXT_SIZE = IconDotTextView.sDefaultDotTextSize;
        if (typedArray != null) {
            this.mSize = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_size, DEFAULT_SIZE);
            this.mColor = typedArray.getColor(R.styleable.IconDotTextView_dot_color, DEFAULT_COLOR);
            String text = typedArray.getString(R.styleable.IconDotTextView_dot_text);
            int textSize = typedArray.getDimensionPixelSize(R.styleable.IconDotTextView_dot_textSize, DEFAULT_TEXT_SIZE);
            int textColor = typedArray.getColor(R.styleable.IconDotTextView_dot_textColor, -1);
            this.textConfig = new TextConfig(text, textSize, textColor);
            this.textConfig.setMaxHeight(this.mSize);
            this.textConfig.setMaxWidth(this.mSize);
        }
        this.mPaint = new Paint(1);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public int getHeight() {
        return Math.min(this.getDesiredHeight(), this.mMaxHeight);
    }

    @Override
    public int getWidth() {
        return Math.min(this.getDesiredWidth(), this.mMaxWidth);
    }

    @Override
    public int getDesiredHeight() {
        return this.mSize;
    }

    @Override
    public int getDesiredWidth() {
        return this.mSize;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
        if (this.textConfig != null) {
            this.textConfig.setMaxWidth(Math.min(maxWidth, this.mSize));
        }
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
        if (this.textConfig != null) {
            this.textConfig.setMaxHeight(Math.min(maxHeight, this.mSize));
        }
    }

    @Override
    public boolean setState(int[] state) {
        return false;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        int radius = this.mSize / 2;
        canvas.translate((float)((this.getWidth() - this.mSize) / 2), (float)((this.getHeight() - this.mSize) / 2));
        canvas.drawCircle((float)radius, (float)radius, (float)radius, this.mPaint);
        canvas.restore();
        if (this.textConfig != null) {
            canvas.save();
            int tLeft = Math.max(0, (this.getWidth() - this.textConfig.getWidth()) / 2);
            int tTop = Math.max(0, (this.getHeight() - this.textConfig.getHeight()) / 2);
            canvas.translate((float)tLeft, (float)tTop);
            canvas.clipRect(0, 0, this.getWidth() - tLeft, this.getHeight() - tTop);
            this.textConfig.draw(canvas);
            canvas.restore();
        }
    }

    public void setSize(int size) {
        if (this.mSize != size) {
            this.mSize = size;
            if (this.textConfig != null) {
                this.textConfig.setMaxHeight(Math.min(this.mMaxHeight, size));
                this.textConfig.setMaxWidth(Math.min(this.mMaxWidth, size));
            }
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setColor(@ColorInt int color) {
        if (this.mColor != color) {
            this.mPaint.setColor(color);
        }
    }

    static {
        DEFAULT_COLOR = Color.rgb((int)211, (int)47, (int)47);
    }
}

