/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SeverityScoreSummary {
    private final double low;
    private final double medium;
    private final double high;
    private final Map<String, Object> additionalProperties;

    private SeverityScoreSummary(double low, double medium, double high, Map<String, Object> additionalProperties) {
        this.low = low;
        this.medium = medium;
        this.high = high;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="low")
    public double getLow() {
        return this.low;
    }

    @JsonProperty(value="medium")
    public double getMedium() {
        return this.medium;
    }

    @JsonProperty(value="high")
    public double getHigh() {
        return this.high;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SeverityScoreSummary && this.equalTo((SeverityScoreSummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SeverityScoreSummary other) {
        return this.low == other.low && this.medium == other.medium && this.high == other.high;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.medium, this.high);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LowStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LowStage,
    MediumStage,
    HighStage,
    _FinalStage {
        private double low;
        private double medium;
        private double high;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SeverityScoreSummary other) {
            this.low(other.getLow());
            this.medium(other.getMedium());
            this.high(other.getHigh());
            return this;
        }

        @Override
        @JsonSetter(value="low")
        public MediumStage low(double low) {
            this.low = low;
            return this;
        }

        @Override
        @JsonSetter(value="medium")
        public HighStage medium(double medium) {
            this.medium = medium;
            return this;
        }

        @Override
        @JsonSetter(value="high")
        public _FinalStage high(double high) {
            this.high = high;
            return this;
        }

        @Override
        public SeverityScoreSummary build() {
            return new SeverityScoreSummary(this.low, this.medium, this.high, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SeverityScoreSummary build();
    }

    public static interface HighStage {
        public _FinalStage high(double var1);
    }

    public static interface MediumStage {
        public HighStage medium(double var1);
    }

    public static interface LowStage {
        public MediumStage low(double var1);

        public Builder from(SeverityScoreSummary var1);
    }
}

