/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.Sentiment;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SentimentAnalysisResult {
    private final String text;
    private final int start;
    private final int end;
    private final Sentiment sentiment;
    private final double confidence;
    private final Optional<String> speaker;
    private final Map<String, Object> additionalProperties;

    private SentimentAnalysisResult(String text, int start, int end, Sentiment sentiment, double confidence, Optional<String> speaker, Map<String, Object> additionalProperties) {
        this.text = text;
        this.start = start;
        this.end = end;
        this.sentiment = sentiment;
        this.confidence = confidence;
        this.speaker = speaker;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    @JsonProperty(value="sentiment")
    public Sentiment getSentiment() {
        return this.sentiment;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="speaker")
    public Optional<String> getSpeaker() {
        return this.speaker;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SentimentAnalysisResult && this.equalTo((SentimentAnalysisResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SentimentAnalysisResult other) {
        return this.text.equals(other.text) && this.start == other.start && this.end == other.end && this.sentiment.equals(other.sentiment) && this.confidence == other.confidence && this.speaker.equals(other.speaker);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.start, this.end, this.sentiment, this.confidence, this.speaker);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    StartStage,
    EndStage,
    SentimentStage,
    ConfidenceStage,
    _FinalStage {
        private String text;
        private int start;
        private int end;
        private Sentiment sentiment;
        private double confidence;
        private Optional<String> speaker = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SentimentAnalysisResult other) {
            this.text(other.getText());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.sentiment(other.getSentiment());
            this.confidence(other.getConfidence());
            this.speaker(other.getSpeaker());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public StartStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public SentimentStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        @JsonSetter(value="sentiment")
        public ConfidenceStage sentiment(Sentiment sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public _FinalStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage speaker(String speaker) {
            this.speaker = Optional.of(speaker);
            return this;
        }

        @Override
        @JsonSetter(value="speaker", nulls=Nulls.SKIP)
        public _FinalStage speaker(Optional<String> speaker) {
            this.speaker = speaker;
            return this;
        }

        @Override
        public SentimentAnalysisResult build() {
            return new SentimentAnalysisResult(this.text, this.start, this.end, this.sentiment, this.confidence, this.speaker, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SentimentAnalysisResult build();

        public _FinalStage speaker(Optional<String> var1);

        public _FinalStage speaker(String var1);
    }

    public static interface ConfidenceStage {
        public _FinalStage confidence(double var1);
    }

    public static interface SentimentStage {
        public ConfidenceStage sentiment(Sentiment var1);
    }

    public static interface EndStage {
        public SentimentStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);
    }

    public static interface TextStage {
        public StartStage text(String var1);

        public Builder from(SentimentAnalysisResult var1);
    }
}

