/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.ITranscriptOptionalParams;
import com.assemblyai.api.resources.transcripts.types.PiiPolicy;
import com.assemblyai.api.resources.transcripts.types.RedactPiiAudioQuality;
import com.assemblyai.api.resources.transcripts.types.SpeechModel;
import com.assemblyai.api.resources.transcripts.types.SubstitutionPolicy;
import com.assemblyai.api.resources.transcripts.types.SummaryModel;
import com.assemblyai.api.resources.transcripts.types.SummaryType;
import com.assemblyai.api.resources.transcripts.types.TranscriptBoostParam;
import com.assemblyai.api.resources.transcripts.types.TranscriptCustomSpelling;
import com.assemblyai.api.resources.transcripts.types.TranscriptLanguageCode;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptParams
implements ITranscriptOptionalParams {
    private final Optional<TranscriptLanguageCode> languageCode;
    private final Optional<Boolean> punctuate;
    private final Optional<Boolean> formatText;
    private final Optional<Boolean> dualChannel;
    private final Optional<SpeechModel> speechModel;
    private final Optional<String> webhookUrl;
    private final Optional<String> webhookAuthHeaderName;
    private final Optional<String> webhookAuthHeaderValue;
    private final Optional<Boolean> autoHighlights;
    private final Optional<Integer> audioStartFrom;
    private final Optional<Integer> audioEndAt;
    private final Optional<List<String>> wordBoost;
    private final Optional<TranscriptBoostParam> boostParam;
    private final Optional<Boolean> filterProfanity;
    private final Optional<Boolean> redactPii;
    private final Optional<Boolean> redactPiiAudio;
    private final Optional<RedactPiiAudioQuality> redactPiiAudioQuality;
    private final Optional<List<PiiPolicy>> redactPiiPolicies;
    private final Optional<SubstitutionPolicy> redactPiiSub;
    private final Optional<Boolean> speakerLabels;
    private final Optional<Integer> speakersExpected;
    private final Optional<Boolean> contentSafety;
    private final Optional<Integer> contentSafetyConfidence;
    private final Optional<Boolean> iabCategories;
    private final Optional<Boolean> languageDetection;
    private final Optional<List<TranscriptCustomSpelling>> customSpelling;
    private final Optional<Boolean> disfluencies;
    private final Optional<Boolean> sentimentAnalysis;
    private final Optional<Boolean> autoChapters;
    private final Optional<Boolean> entityDetection;
    private final Optional<Double> speechThreshold;
    private final Optional<Boolean> summarization;
    private final Optional<SummaryModel> summaryModel;
    private final Optional<SummaryType> summaryType;
    private final Optional<Boolean> customTopics;
    private final Optional<List<String>> topics;
    private final String audioUrl;
    private final Map<String, Object> additionalProperties;

    private TranscriptParams(Optional<TranscriptLanguageCode> languageCode, Optional<Boolean> punctuate, Optional<Boolean> formatText, Optional<Boolean> dualChannel, Optional<SpeechModel> speechModel, Optional<String> webhookUrl, Optional<String> webhookAuthHeaderName, Optional<String> webhookAuthHeaderValue, Optional<Boolean> autoHighlights, Optional<Integer> audioStartFrom, Optional<Integer> audioEndAt, Optional<List<String>> wordBoost, Optional<TranscriptBoostParam> boostParam, Optional<Boolean> filterProfanity, Optional<Boolean> redactPii, Optional<Boolean> redactPiiAudio, Optional<RedactPiiAudioQuality> redactPiiAudioQuality, Optional<List<PiiPolicy>> redactPiiPolicies, Optional<SubstitutionPolicy> redactPiiSub, Optional<Boolean> speakerLabels, Optional<Integer> speakersExpected, Optional<Boolean> contentSafety, Optional<Integer> contentSafetyConfidence, Optional<Boolean> iabCategories, Optional<Boolean> languageDetection, Optional<List<TranscriptCustomSpelling>> customSpelling, Optional<Boolean> disfluencies, Optional<Boolean> sentimentAnalysis, Optional<Boolean> autoChapters, Optional<Boolean> entityDetection, Optional<Double> speechThreshold, Optional<Boolean> summarization, Optional<SummaryModel> summaryModel, Optional<SummaryType> summaryType, Optional<Boolean> customTopics, Optional<List<String>> topics, String audioUrl, Map<String, Object> additionalProperties) {
        this.languageCode = languageCode;
        this.punctuate = punctuate;
        this.formatText = formatText;
        this.dualChannel = dualChannel;
        this.speechModel = speechModel;
        this.webhookUrl = webhookUrl;
        this.webhookAuthHeaderName = webhookAuthHeaderName;
        this.webhookAuthHeaderValue = webhookAuthHeaderValue;
        this.autoHighlights = autoHighlights;
        this.audioStartFrom = audioStartFrom;
        this.audioEndAt = audioEndAt;
        this.wordBoost = wordBoost;
        this.boostParam = boostParam;
        this.filterProfanity = filterProfanity;
        this.redactPii = redactPii;
        this.redactPiiAudio = redactPiiAudio;
        this.redactPiiAudioQuality = redactPiiAudioQuality;
        this.redactPiiPolicies = redactPiiPolicies;
        this.redactPiiSub = redactPiiSub;
        this.speakerLabels = speakerLabels;
        this.speakersExpected = speakersExpected;
        this.contentSafety = contentSafety;
        this.contentSafetyConfidence = contentSafetyConfidence;
        this.iabCategories = iabCategories;
        this.languageDetection = languageDetection;
        this.customSpelling = customSpelling;
        this.disfluencies = disfluencies;
        this.sentimentAnalysis = sentimentAnalysis;
        this.autoChapters = autoChapters;
        this.entityDetection = entityDetection;
        this.speechThreshold = speechThreshold;
        this.summarization = summarization;
        this.summaryModel = summaryModel;
        this.summaryType = summaryType;
        this.customTopics = customTopics;
        this.topics = topics;
        this.audioUrl = audioUrl;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="language_code")
    public Optional<TranscriptLanguageCode> getLanguageCode() {
        return this.languageCode;
    }

    @Override
    @JsonProperty(value="punctuate")
    public Optional<Boolean> getPunctuate() {
        return this.punctuate;
    }

    @Override
    @JsonProperty(value="format_text")
    public Optional<Boolean> getFormatText() {
        return this.formatText;
    }

    @Override
    @JsonProperty(value="dual_channel")
    public Optional<Boolean> getDualChannel() {
        return this.dualChannel;
    }

    @Override
    @JsonProperty(value="speech_model")
    public Optional<SpeechModel> getSpeechModel() {
        return this.speechModel;
    }

    @Override
    @JsonProperty(value="webhook_url")
    public Optional<String> getWebhookUrl() {
        return this.webhookUrl;
    }

    @Override
    @JsonProperty(value="webhook_auth_header_name")
    public Optional<String> getWebhookAuthHeaderName() {
        return this.webhookAuthHeaderName;
    }

    @Override
    @JsonProperty(value="webhook_auth_header_value")
    public Optional<String> getWebhookAuthHeaderValue() {
        return this.webhookAuthHeaderValue;
    }

    @Override
    @JsonProperty(value="auto_highlights")
    public Optional<Boolean> getAutoHighlights() {
        return this.autoHighlights;
    }

    @Override
    @JsonProperty(value="audio_start_from")
    public Optional<Integer> getAudioStartFrom() {
        return this.audioStartFrom;
    }

    @Override
    @JsonProperty(value="audio_end_at")
    public Optional<Integer> getAudioEndAt() {
        return this.audioEndAt;
    }

    @Override
    @JsonProperty(value="word_boost")
    public Optional<List<String>> getWordBoost() {
        return this.wordBoost;
    }

    @Override
    @JsonProperty(value="boost_param")
    public Optional<TranscriptBoostParam> getBoostParam() {
        return this.boostParam;
    }

    @Override
    @JsonProperty(value="filter_profanity")
    public Optional<Boolean> getFilterProfanity() {
        return this.filterProfanity;
    }

    @Override
    @JsonProperty(value="redact_pii")
    public Optional<Boolean> getRedactPii() {
        return this.redactPii;
    }

    @Override
    @JsonProperty(value="redact_pii_audio")
    public Optional<Boolean> getRedactPiiAudio() {
        return this.redactPiiAudio;
    }

    @Override
    @JsonProperty(value="redact_pii_audio_quality")
    public Optional<RedactPiiAudioQuality> getRedactPiiAudioQuality() {
        return this.redactPiiAudioQuality;
    }

    @Override
    @JsonProperty(value="redact_pii_policies")
    public Optional<List<PiiPolicy>> getRedactPiiPolicies() {
        return this.redactPiiPolicies;
    }

    @Override
    @JsonProperty(value="redact_pii_sub")
    public Optional<SubstitutionPolicy> getRedactPiiSub() {
        return this.redactPiiSub;
    }

    @Override
    @JsonProperty(value="speaker_labels")
    public Optional<Boolean> getSpeakerLabels() {
        return this.speakerLabels;
    }

    @Override
    @JsonProperty(value="speakers_expected")
    public Optional<Integer> getSpeakersExpected() {
        return this.speakersExpected;
    }

    @Override
    @JsonProperty(value="content_safety")
    public Optional<Boolean> getContentSafety() {
        return this.contentSafety;
    }

    @Override
    @JsonProperty(value="content_safety_confidence")
    public Optional<Integer> getContentSafetyConfidence() {
        return this.contentSafetyConfidence;
    }

    @Override
    @JsonProperty(value="iab_categories")
    public Optional<Boolean> getIabCategories() {
        return this.iabCategories;
    }

    @Override
    @JsonProperty(value="language_detection")
    public Optional<Boolean> getLanguageDetection() {
        return this.languageDetection;
    }

    @Override
    @JsonProperty(value="custom_spelling")
    public Optional<List<TranscriptCustomSpelling>> getCustomSpelling() {
        return this.customSpelling;
    }

    @Override
    @JsonProperty(value="disfluencies")
    public Optional<Boolean> getDisfluencies() {
        return this.disfluencies;
    }

    @Override
    @JsonProperty(value="sentiment_analysis")
    public Optional<Boolean> getSentimentAnalysis() {
        return this.sentimentAnalysis;
    }

    @Override
    @JsonProperty(value="auto_chapters")
    public Optional<Boolean> getAutoChapters() {
        return this.autoChapters;
    }

    @Override
    @JsonProperty(value="entity_detection")
    public Optional<Boolean> getEntityDetection() {
        return this.entityDetection;
    }

    @Override
    @JsonProperty(value="speech_threshold")
    public Optional<Double> getSpeechThreshold() {
        return this.speechThreshold;
    }

    @Override
    @JsonProperty(value="summarization")
    public Optional<Boolean> getSummarization() {
        return this.summarization;
    }

    @Override
    @JsonProperty(value="summary_model")
    public Optional<SummaryModel> getSummaryModel() {
        return this.summaryModel;
    }

    @Override
    @JsonProperty(value="summary_type")
    public Optional<SummaryType> getSummaryType() {
        return this.summaryType;
    }

    @Override
    @JsonProperty(value="custom_topics")
    public Optional<Boolean> getCustomTopics() {
        return this.customTopics;
    }

    @Override
    @JsonProperty(value="topics")
    public Optional<List<String>> getTopics() {
        return this.topics;
    }

    @JsonProperty(value="audio_url")
    public String getAudioUrl() {
        return this.audioUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptParams && this.equalTo((TranscriptParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptParams other) {
        return this.languageCode.equals(other.languageCode) && this.punctuate.equals(other.punctuate) && this.formatText.equals(other.formatText) && this.dualChannel.equals(other.dualChannel) && this.speechModel.equals(other.speechModel) && this.webhookUrl.equals(other.webhookUrl) && this.webhookAuthHeaderName.equals(other.webhookAuthHeaderName) && this.webhookAuthHeaderValue.equals(other.webhookAuthHeaderValue) && this.autoHighlights.equals(other.autoHighlights) && this.audioStartFrom.equals(other.audioStartFrom) && this.audioEndAt.equals(other.audioEndAt) && this.wordBoost.equals(other.wordBoost) && this.boostParam.equals(other.boostParam) && this.filterProfanity.equals(other.filterProfanity) && this.redactPii.equals(other.redactPii) && this.redactPiiAudio.equals(other.redactPiiAudio) && this.redactPiiAudioQuality.equals(other.redactPiiAudioQuality) && this.redactPiiPolicies.equals(other.redactPiiPolicies) && this.redactPiiSub.equals(other.redactPiiSub) && this.speakerLabels.equals(other.speakerLabels) && this.speakersExpected.equals(other.speakersExpected) && this.contentSafety.equals(other.contentSafety) && this.contentSafetyConfidence.equals(other.contentSafetyConfidence) && this.iabCategories.equals(other.iabCategories) && this.languageDetection.equals(other.languageDetection) && this.customSpelling.equals(other.customSpelling) && this.disfluencies.equals(other.disfluencies) && this.sentimentAnalysis.equals(other.sentimentAnalysis) && this.autoChapters.equals(other.autoChapters) && this.entityDetection.equals(other.entityDetection) && this.speechThreshold.equals(other.speechThreshold) && this.summarization.equals(other.summarization) && this.summaryModel.equals(other.summaryModel) && this.summaryType.equals(other.summaryType) && this.customTopics.equals(other.customTopics) && this.topics.equals(other.topics) && this.audioUrl.equals(other.audioUrl);
    }

    public int hashCode() {
        return Objects.hash(this.languageCode, this.punctuate, this.formatText, this.dualChannel, this.speechModel, this.webhookUrl, this.webhookAuthHeaderName, this.webhookAuthHeaderValue, this.autoHighlights, this.audioStartFrom, this.audioEndAt, this.wordBoost, this.boostParam, this.filterProfanity, this.redactPii, this.redactPiiAudio, this.redactPiiAudioQuality, this.redactPiiPolicies, this.redactPiiSub, this.speakerLabels, this.speakersExpected, this.contentSafety, this.contentSafetyConfidence, this.iabCategories, this.languageDetection, this.customSpelling, this.disfluencies, this.sentimentAnalysis, this.autoChapters, this.entityDetection, this.speechThreshold, this.summarization, this.summaryModel, this.summaryType, this.customTopics, this.topics, this.audioUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AudioUrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AudioUrlStage,
    _FinalStage {
        private String audioUrl;
        private Optional<List<String>> topics = Optional.empty();
        private Optional<Boolean> customTopics = Optional.empty();
        private Optional<SummaryType> summaryType = Optional.empty();
        private Optional<SummaryModel> summaryModel = Optional.empty();
        private Optional<Boolean> summarization = Optional.empty();
        private Optional<Double> speechThreshold = Optional.empty();
        private Optional<Boolean> entityDetection = Optional.empty();
        private Optional<Boolean> autoChapters = Optional.empty();
        private Optional<Boolean> sentimentAnalysis = Optional.empty();
        private Optional<Boolean> disfluencies = Optional.empty();
        private Optional<List<TranscriptCustomSpelling>> customSpelling = Optional.empty();
        private Optional<Boolean> languageDetection = Optional.empty();
        private Optional<Boolean> iabCategories = Optional.empty();
        private Optional<Integer> contentSafetyConfidence = Optional.empty();
        private Optional<Boolean> contentSafety = Optional.empty();
        private Optional<Integer> speakersExpected = Optional.empty();
        private Optional<Boolean> speakerLabels = Optional.empty();
        private Optional<SubstitutionPolicy> redactPiiSub = Optional.empty();
        private Optional<List<PiiPolicy>> redactPiiPolicies = Optional.empty();
        private Optional<RedactPiiAudioQuality> redactPiiAudioQuality = Optional.empty();
        private Optional<Boolean> redactPiiAudio = Optional.empty();
        private Optional<Boolean> redactPii = Optional.empty();
        private Optional<Boolean> filterProfanity = Optional.empty();
        private Optional<TranscriptBoostParam> boostParam = Optional.empty();
        private Optional<List<String>> wordBoost = Optional.empty();
        private Optional<Integer> audioEndAt = Optional.empty();
        private Optional<Integer> audioStartFrom = Optional.empty();
        private Optional<Boolean> autoHighlights = Optional.empty();
        private Optional<String> webhookAuthHeaderValue = Optional.empty();
        private Optional<String> webhookAuthHeaderName = Optional.empty();
        private Optional<String> webhookUrl = Optional.empty();
        private Optional<SpeechModel> speechModel = Optional.empty();
        private Optional<Boolean> dualChannel = Optional.empty();
        private Optional<Boolean> formatText = Optional.empty();
        private Optional<Boolean> punctuate = Optional.empty();
        private Optional<TranscriptLanguageCode> languageCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptParams other) {
            this.languageCode(other.getLanguageCode());
            this.punctuate(other.getPunctuate());
            this.formatText(other.getFormatText());
            this.dualChannel(other.getDualChannel());
            this.speechModel(other.getSpeechModel());
            this.webhookUrl(other.getWebhookUrl());
            this.webhookAuthHeaderName(other.getWebhookAuthHeaderName());
            this.webhookAuthHeaderValue(other.getWebhookAuthHeaderValue());
            this.autoHighlights(other.getAutoHighlights());
            this.audioStartFrom(other.getAudioStartFrom());
            this.audioEndAt(other.getAudioEndAt());
            this.wordBoost(other.getWordBoost());
            this.boostParam(other.getBoostParam());
            this.filterProfanity(other.getFilterProfanity());
            this.redactPii(other.getRedactPii());
            this.redactPiiAudio(other.getRedactPiiAudio());
            this.redactPiiAudioQuality(other.getRedactPiiAudioQuality());
            this.redactPiiPolicies(other.getRedactPiiPolicies());
            this.redactPiiSub(other.getRedactPiiSub());
            this.speakerLabels(other.getSpeakerLabels());
            this.speakersExpected(other.getSpeakersExpected());
            this.contentSafety(other.getContentSafety());
            this.contentSafetyConfidence(other.getContentSafetyConfidence());
            this.iabCategories(other.getIabCategories());
            this.languageDetection(other.getLanguageDetection());
            this.customSpelling(other.getCustomSpelling());
            this.disfluencies(other.getDisfluencies());
            this.sentimentAnalysis(other.getSentimentAnalysis());
            this.autoChapters(other.getAutoChapters());
            this.entityDetection(other.getEntityDetection());
            this.speechThreshold(other.getSpeechThreshold());
            this.summarization(other.getSummarization());
            this.summaryModel(other.getSummaryModel());
            this.summaryType(other.getSummaryType());
            this.customTopics(other.getCustomTopics());
            this.topics(other.getTopics());
            this.audioUrl(other.getAudioUrl());
            return this;
        }

        @Override
        @JsonSetter(value="audio_url")
        public _FinalStage audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        @Override
        public _FinalStage topics(List<String> topics) {
            this.topics = Optional.of(topics);
            return this;
        }

        @Override
        @JsonSetter(value="topics", nulls=Nulls.SKIP)
        public _FinalStage topics(Optional<List<String>> topics) {
            this.topics = topics;
            return this;
        }

        @Override
        public _FinalStage customTopics(Boolean customTopics) {
            this.customTopics = Optional.of(customTopics);
            return this;
        }

        @Override
        @JsonSetter(value="custom_topics", nulls=Nulls.SKIP)
        public _FinalStage customTopics(Optional<Boolean> customTopics) {
            this.customTopics = customTopics;
            return this;
        }

        @Override
        public _FinalStage summaryType(SummaryType summaryType) {
            this.summaryType = Optional.of(summaryType);
            return this;
        }

        @Override
        @JsonSetter(value="summary_type", nulls=Nulls.SKIP)
        public _FinalStage summaryType(Optional<SummaryType> summaryType) {
            this.summaryType = summaryType;
            return this;
        }

        @Override
        public _FinalStage summaryModel(SummaryModel summaryModel) {
            this.summaryModel = Optional.of(summaryModel);
            return this;
        }

        @Override
        @JsonSetter(value="summary_model", nulls=Nulls.SKIP)
        public _FinalStage summaryModel(Optional<SummaryModel> summaryModel) {
            this.summaryModel = summaryModel;
            return this;
        }

        @Override
        public _FinalStage summarization(Boolean summarization) {
            this.summarization = Optional.of(summarization);
            return this;
        }

        @Override
        @JsonSetter(value="summarization", nulls=Nulls.SKIP)
        public _FinalStage summarization(Optional<Boolean> summarization) {
            this.summarization = summarization;
            return this;
        }

        @Override
        public _FinalStage speechThreshold(Double speechThreshold) {
            this.speechThreshold = Optional.of(speechThreshold);
            return this;
        }

        @Override
        @JsonSetter(value="speech_threshold", nulls=Nulls.SKIP)
        public _FinalStage speechThreshold(Optional<Double> speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        @Override
        public _FinalStage entityDetection(Boolean entityDetection) {
            this.entityDetection = Optional.of(entityDetection);
            return this;
        }

        @Override
        @JsonSetter(value="entity_detection", nulls=Nulls.SKIP)
        public _FinalStage entityDetection(Optional<Boolean> entityDetection) {
            this.entityDetection = entityDetection;
            return this;
        }

        @Override
        public _FinalStage autoChapters(Boolean autoChapters) {
            this.autoChapters = Optional.of(autoChapters);
            return this;
        }

        @Override
        @JsonSetter(value="auto_chapters", nulls=Nulls.SKIP)
        public _FinalStage autoChapters(Optional<Boolean> autoChapters) {
            this.autoChapters = autoChapters;
            return this;
        }

        @Override
        public _FinalStage sentimentAnalysis(Boolean sentimentAnalysis) {
            this.sentimentAnalysis = Optional.of(sentimentAnalysis);
            return this;
        }

        @Override
        @JsonSetter(value="sentiment_analysis", nulls=Nulls.SKIP)
        public _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        @Override
        public _FinalStage disfluencies(Boolean disfluencies) {
            this.disfluencies = Optional.of(disfluencies);
            return this;
        }

        @Override
        @JsonSetter(value="disfluencies", nulls=Nulls.SKIP)
        public _FinalStage disfluencies(Optional<Boolean> disfluencies) {
            this.disfluencies = disfluencies;
            return this;
        }

        @Override
        public _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling) {
            this.customSpelling = Optional.of(customSpelling);
            return this;
        }

        @Override
        @JsonSetter(value="custom_spelling", nulls=Nulls.SKIP)
        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling) {
            this.customSpelling = customSpelling;
            return this;
        }

        @Override
        public _FinalStage languageDetection(Boolean languageDetection) {
            this.languageDetection = Optional.of(languageDetection);
            return this;
        }

        @Override
        @JsonSetter(value="language_detection", nulls=Nulls.SKIP)
        public _FinalStage languageDetection(Optional<Boolean> languageDetection) {
            this.languageDetection = languageDetection;
            return this;
        }

        @Override
        public _FinalStage iabCategories(Boolean iabCategories) {
            this.iabCategories = Optional.of(iabCategories);
            return this;
        }

        @Override
        @JsonSetter(value="iab_categories", nulls=Nulls.SKIP)
        public _FinalStage iabCategories(Optional<Boolean> iabCategories) {
            this.iabCategories = iabCategories;
            return this;
        }

        @Override
        public _FinalStage contentSafetyConfidence(Integer contentSafetyConfidence) {
            this.contentSafetyConfidence = Optional.of(contentSafetyConfidence);
            return this;
        }

        @Override
        @JsonSetter(value="content_safety_confidence", nulls=Nulls.SKIP)
        public _FinalStage contentSafetyConfidence(Optional<Integer> contentSafetyConfidence) {
            this.contentSafetyConfidence = contentSafetyConfidence;
            return this;
        }

        @Override
        public _FinalStage contentSafety(Boolean contentSafety) {
            this.contentSafety = Optional.of(contentSafety);
            return this;
        }

        @Override
        @JsonSetter(value="content_safety", nulls=Nulls.SKIP)
        public _FinalStage contentSafety(Optional<Boolean> contentSafety) {
            this.contentSafety = contentSafety;
            return this;
        }

        @Override
        public _FinalStage speakersExpected(Integer speakersExpected) {
            this.speakersExpected = Optional.of(speakersExpected);
            return this;
        }

        @Override
        @JsonSetter(value="speakers_expected", nulls=Nulls.SKIP)
        public _FinalStage speakersExpected(Optional<Integer> speakersExpected) {
            this.speakersExpected = speakersExpected;
            return this;
        }

        @Override
        public _FinalStage speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = Optional.of(speakerLabels);
            return this;
        }

        @Override
        @JsonSetter(value="speaker_labels", nulls=Nulls.SKIP)
        public _FinalStage speakerLabels(Optional<Boolean> speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        @Override
        public _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub) {
            this.redactPiiSub = Optional.of(redactPiiSub);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_sub", nulls=Nulls.SKIP)
        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub) {
            this.redactPiiSub = redactPiiSub;
            return this;
        }

        @Override
        public _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies) {
            this.redactPiiPolicies = Optional.of(redactPiiPolicies);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_policies", nulls=Nulls.SKIP)
        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies) {
            this.redactPiiPolicies = redactPiiPolicies;
            return this;
        }

        @Override
        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality) {
            this.redactPiiAudioQuality = Optional.of(redactPiiAudioQuality);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_audio_quality", nulls=Nulls.SKIP)
        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality) {
            this.redactPiiAudioQuality = redactPiiAudioQuality;
            return this;
        }

        @Override
        public _FinalStage redactPiiAudio(Boolean redactPiiAudio) {
            this.redactPiiAudio = Optional.of(redactPiiAudio);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_audio", nulls=Nulls.SKIP)
        public _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio) {
            this.redactPiiAudio = redactPiiAudio;
            return this;
        }

        @Override
        public _FinalStage redactPii(Boolean redactPii) {
            this.redactPii = Optional.of(redactPii);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii", nulls=Nulls.SKIP)
        public _FinalStage redactPii(Optional<Boolean> redactPii) {
            this.redactPii = redactPii;
            return this;
        }

        @Override
        public _FinalStage filterProfanity(Boolean filterProfanity) {
            this.filterProfanity = Optional.of(filterProfanity);
            return this;
        }

        @Override
        @JsonSetter(value="filter_profanity", nulls=Nulls.SKIP)
        public _FinalStage filterProfanity(Optional<Boolean> filterProfanity) {
            this.filterProfanity = filterProfanity;
            return this;
        }

        @Override
        public _FinalStage boostParam(TranscriptBoostParam boostParam) {
            this.boostParam = Optional.of(boostParam);
            return this;
        }

        @Override
        @JsonSetter(value="boost_param", nulls=Nulls.SKIP)
        public _FinalStage boostParam(Optional<TranscriptBoostParam> boostParam) {
            this.boostParam = boostParam;
            return this;
        }

        @Override
        public _FinalStage wordBoost(List<String> wordBoost) {
            this.wordBoost = Optional.of(wordBoost);
            return this;
        }

        @Override
        @JsonSetter(value="word_boost", nulls=Nulls.SKIP)
        public _FinalStage wordBoost(Optional<List<String>> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        @Override
        public _FinalStage audioEndAt(Integer audioEndAt) {
            this.audioEndAt = Optional.of(audioEndAt);
            return this;
        }

        @Override
        @JsonSetter(value="audio_end_at", nulls=Nulls.SKIP)
        public _FinalStage audioEndAt(Optional<Integer> audioEndAt) {
            this.audioEndAt = audioEndAt;
            return this;
        }

        @Override
        public _FinalStage audioStartFrom(Integer audioStartFrom) {
            this.audioStartFrom = Optional.of(audioStartFrom);
            return this;
        }

        @Override
        @JsonSetter(value="audio_start_from", nulls=Nulls.SKIP)
        public _FinalStage audioStartFrom(Optional<Integer> audioStartFrom) {
            this.audioStartFrom = audioStartFrom;
            return this;
        }

        @Override
        public _FinalStage autoHighlights(Boolean autoHighlights) {
            this.autoHighlights = Optional.of(autoHighlights);
            return this;
        }

        @Override
        @JsonSetter(value="auto_highlights", nulls=Nulls.SKIP)
        public _FinalStage autoHighlights(Optional<Boolean> autoHighlights) {
            this.autoHighlights = autoHighlights;
            return this;
        }

        @Override
        public _FinalStage webhookAuthHeaderValue(String webhookAuthHeaderValue) {
            this.webhookAuthHeaderValue = Optional.of(webhookAuthHeaderValue);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_auth_header_value", nulls=Nulls.SKIP)
        public _FinalStage webhookAuthHeaderValue(Optional<String> webhookAuthHeaderValue) {
            this.webhookAuthHeaderValue = webhookAuthHeaderValue;
            return this;
        }

        @Override
        public _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName) {
            this.webhookAuthHeaderName = Optional.of(webhookAuthHeaderName);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_auth_header_name", nulls=Nulls.SKIP)
        public _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName) {
            this.webhookAuthHeaderName = webhookAuthHeaderName;
            return this;
        }

        @Override
        public _FinalStage webhookUrl(String webhookUrl) {
            this.webhookUrl = Optional.of(webhookUrl);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_url", nulls=Nulls.SKIP)
        public _FinalStage webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        @Override
        public _FinalStage speechModel(SpeechModel speechModel) {
            this.speechModel = Optional.of(speechModel);
            return this;
        }

        @Override
        @JsonSetter(value="speech_model", nulls=Nulls.SKIP)
        public _FinalStage speechModel(Optional<SpeechModel> speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        @Override
        public _FinalStage dualChannel(Boolean dualChannel) {
            this.dualChannel = Optional.of(dualChannel);
            return this;
        }

        @Override
        @JsonSetter(value="dual_channel", nulls=Nulls.SKIP)
        public _FinalStage dualChannel(Optional<Boolean> dualChannel) {
            this.dualChannel = dualChannel;
            return this;
        }

        @Override
        public _FinalStage formatText(Boolean formatText) {
            this.formatText = Optional.of(formatText);
            return this;
        }

        @Override
        @JsonSetter(value="format_text", nulls=Nulls.SKIP)
        public _FinalStage formatText(Optional<Boolean> formatText) {
            this.formatText = formatText;
            return this;
        }

        @Override
        public _FinalStage punctuate(Boolean punctuate) {
            this.punctuate = Optional.of(punctuate);
            return this;
        }

        @Override
        @JsonSetter(value="punctuate", nulls=Nulls.SKIP)
        public _FinalStage punctuate(Optional<Boolean> punctuate) {
            this.punctuate = punctuate;
            return this;
        }

        @Override
        public _FinalStage languageCode(TranscriptLanguageCode languageCode) {
            this.languageCode = Optional.of(languageCode);
            return this;
        }

        @Override
        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public TranscriptParams build() {
            return new TranscriptParams(this.languageCode, this.punctuate, this.formatText, this.dualChannel, this.speechModel, this.webhookUrl, this.webhookAuthHeaderName, this.webhookAuthHeaderValue, this.autoHighlights, this.audioStartFrom, this.audioEndAt, this.wordBoost, this.boostParam, this.filterProfanity, this.redactPii, this.redactPiiAudio, this.redactPiiAudioQuality, this.redactPiiPolicies, this.redactPiiSub, this.speakerLabels, this.speakersExpected, this.contentSafety, this.contentSafetyConfidence, this.iabCategories, this.languageDetection, this.customSpelling, this.disfluencies, this.sentimentAnalysis, this.autoChapters, this.entityDetection, this.speechThreshold, this.summarization, this.summaryModel, this.summaryType, this.customTopics, this.topics, this.audioUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptParams build();

        public _FinalStage languageCode(Optional<TranscriptLanguageCode> var1);

        public _FinalStage languageCode(TranscriptLanguageCode var1);

        public _FinalStage punctuate(Optional<Boolean> var1);

        public _FinalStage punctuate(Boolean var1);

        public _FinalStage formatText(Optional<Boolean> var1);

        public _FinalStage formatText(Boolean var1);

        public _FinalStage dualChannel(Optional<Boolean> var1);

        public _FinalStage dualChannel(Boolean var1);

        public _FinalStage speechModel(Optional<SpeechModel> var1);

        public _FinalStage speechModel(SpeechModel var1);

        public _FinalStage webhookUrl(Optional<String> var1);

        public _FinalStage webhookUrl(String var1);

        public _FinalStage webhookAuthHeaderName(Optional<String> var1);

        public _FinalStage webhookAuthHeaderName(String var1);

        public _FinalStage webhookAuthHeaderValue(Optional<String> var1);

        public _FinalStage webhookAuthHeaderValue(String var1);

        public _FinalStage autoHighlights(Optional<Boolean> var1);

        public _FinalStage autoHighlights(Boolean var1);

        public _FinalStage audioStartFrom(Optional<Integer> var1);

        public _FinalStage audioStartFrom(Integer var1);

        public _FinalStage audioEndAt(Optional<Integer> var1);

        public _FinalStage audioEndAt(Integer var1);

        public _FinalStage wordBoost(Optional<List<String>> var1);

        public _FinalStage wordBoost(List<String> var1);

        public _FinalStage boostParam(Optional<TranscriptBoostParam> var1);

        public _FinalStage boostParam(TranscriptBoostParam var1);

        public _FinalStage filterProfanity(Optional<Boolean> var1);

        public _FinalStage filterProfanity(Boolean var1);

        public _FinalStage redactPii(Optional<Boolean> var1);

        public _FinalStage redactPii(Boolean var1);

        public _FinalStage redactPiiAudio(Optional<Boolean> var1);

        public _FinalStage redactPiiAudio(Boolean var1);

        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> var1);

        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality var1);

        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> var1);

        public _FinalStage redactPiiPolicies(List<PiiPolicy> var1);

        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> var1);

        public _FinalStage redactPiiSub(SubstitutionPolicy var1);

        public _FinalStage speakerLabels(Optional<Boolean> var1);

        public _FinalStage speakerLabels(Boolean var1);

        public _FinalStage speakersExpected(Optional<Integer> var1);

        public _FinalStage speakersExpected(Integer var1);

        public _FinalStage contentSafety(Optional<Boolean> var1);

        public _FinalStage contentSafety(Boolean var1);

        public _FinalStage contentSafetyConfidence(Optional<Integer> var1);

        public _FinalStage contentSafetyConfidence(Integer var1);

        public _FinalStage iabCategories(Optional<Boolean> var1);

        public _FinalStage iabCategories(Boolean var1);

        public _FinalStage languageDetection(Optional<Boolean> var1);

        public _FinalStage languageDetection(Boolean var1);

        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> var1);

        public _FinalStage customSpelling(List<TranscriptCustomSpelling> var1);

        public _FinalStage disfluencies(Optional<Boolean> var1);

        public _FinalStage disfluencies(Boolean var1);

        public _FinalStage sentimentAnalysis(Optional<Boolean> var1);

        public _FinalStage sentimentAnalysis(Boolean var1);

        public _FinalStage autoChapters(Optional<Boolean> var1);

        public _FinalStage autoChapters(Boolean var1);

        public _FinalStage entityDetection(Optional<Boolean> var1);

        public _FinalStage entityDetection(Boolean var1);

        public _FinalStage speechThreshold(Optional<Double> var1);

        public _FinalStage speechThreshold(Double var1);

        public _FinalStage summarization(Optional<Boolean> var1);

        public _FinalStage summarization(Boolean var1);

        public _FinalStage summaryModel(Optional<SummaryModel> var1);

        public _FinalStage summaryModel(SummaryModel var1);

        public _FinalStage summaryType(Optional<SummaryType> var1);

        public _FinalStage summaryType(SummaryType var1);

        public _FinalStage customTopics(Optional<Boolean> var1);

        public _FinalStage customTopics(Boolean var1);

        public _FinalStage topics(Optional<List<String>> var1);

        public _FinalStage topics(List<String> var1);
    }

    public static interface AudioUrlStage {
        public _FinalStage audioUrl(String var1);

        public Builder from(TranscriptParams var1);
    }
}

