/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Word {
    private final int start;
    private final int end;
    private final double confidence;
    private final String text;
    private final Map<String, Object> additionalProperties;

    private Word(int start, int end, double confidence, String text, Map<String, Object> additionalProperties) {
        this.start = start;
        this.end = end;
        this.confidence = confidence;
        this.text = text;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Word && this.equalTo((Word)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Word other) {
        return this.start == other.start && this.end == other.end && this.confidence == other.confidence && this.text.equals(other.text);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.confidence, this.text);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StartStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StartStage,
    EndStage,
    ConfidenceStage,
    TextStage,
    _FinalStage {
        private int start;
        private int end;
        private double confidence;
        private String text;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Word other) {
            this.start(other.getStart());
            this.end(other.getEnd());
            this.confidence(other.getConfidence());
            this.text(other.getText());
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public ConfidenceStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public TextStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public Word build() {
            return new Word(this.start, this.end, this.confidence, this.text, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Word build();
    }

    public static interface TextStage {
        public _FinalStage text(String var1);
    }

    public static interface ConfidenceStage {
        public TextStage confidence(double var1);
    }

    public static interface EndStage {
        public ConfidenceStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);

        public Builder from(Word var1);
    }
}

