/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.LemurActionItemsResponse;
import com.assemblyai.api.resources.lemur.types.LemurQuestionAnswerResponse;
import com.assemblyai.api.resources.lemur.types.LemurSummaryResponse;
import com.assemblyai.api.resources.lemur.types.LemurTaskResponse;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class LemurResponse {
    private final Object value;
    private final int type;

    private LemurResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((LemurTaskResponse)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((LemurSummaryResponse)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((LemurQuestionAnswerResponse)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((LemurActionItemsResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurResponse && this.equalTo((LemurResponse)other);
    }

    private boolean equalTo(LemurResponse other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static LemurResponse of(LemurTaskResponse value) {
        return new LemurResponse(value, 0);
    }

    public static LemurResponse of(LemurSummaryResponse value) {
        return new LemurResponse(value, 1);
    }

    public static LemurResponse of(LemurQuestionAnswerResponse value) {
        return new LemurResponse(value, 2);
    }

    public static LemurResponse of(LemurActionItemsResponse value) {
        return new LemurResponse(value, 3);
    }

    static final class Deserializer
    extends StdDeserializer<LemurResponse> {
        Deserializer() {
            super(LemurResponse.class);
        }

        public LemurResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return LemurResponse.of((LemurTaskResponse)ObjectMappers.JSON_MAPPER.convertValue(value, LemurTaskResponse.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return LemurResponse.of((LemurSummaryResponse)ObjectMappers.JSON_MAPPER.convertValue(value, LemurSummaryResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return LemurResponse.of((LemurQuestionAnswerResponse)ObjectMappers.JSON_MAPPER.convertValue(value, LemurQuestionAnswerResponse.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            return LemurResponse.of((LemurActionItemsResponse)ObjectMappers.JSON_MAPPER.convertValue(value, LemurActionItemsResponse.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(LemurTaskResponse var1);

        public T visit(LemurSummaryResponse var1);

        public T visit(LemurQuestionAnswerResponse var1);

        public T visit(LemurActionItemsResponse var1);
    }
}

