/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class LemurModel {
    public static final LemurModel BASIC = new LemurModel(Value.BASIC, "basic");
    public static final LemurModel ANTHROPIC_CLAUDE2_1 = new LemurModel(Value.ANTHROPIC_CLAUDE2_1, "anthropic/claude-2-1");
    public static final LemurModel DEFAULT = new LemurModel(Value.DEFAULT, "default");
    public static final LemurModel ASSEMBLYAI_MISTRAL7B = new LemurModel(Value.ASSEMBLYAI_MISTRAL7B, "assemblyai/mistral-7b");
    private final Value value;
    private final String string;

    LemurModel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LemurModel && this.string.equals(((LemurModel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case BASIC: {
                return visitor.visitBasic();
            }
            case ANTHROPIC_CLAUDE2_1: {
                return visitor.visitAnthropicClaude2_1();
            }
            case DEFAULT: {
                return visitor.visitDefault();
            }
            case ASSEMBLYAI_MISTRAL7B: {
                return visitor.visitAssemblyaiMistral7b();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LemurModel valueOf(String value) {
        switch (value) {
            case "basic": {
                return BASIC;
            }
            case "anthropic/claude-2-1": {
                return ANTHROPIC_CLAUDE2_1;
            }
            case "default": {
                return DEFAULT;
            }
            case "assemblyai/mistral-7b": {
                return ASSEMBLYAI_MISTRAL7B;
            }
        }
        return new LemurModel(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitDefault();

        public T visitBasic();

        public T visitAssemblyaiMistral7b();

        public T visitAnthropicClaude2_1();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        DEFAULT,
        BASIC,
        ASSEMBLYAI_MISTRAL7B,
        ANTHROPIC_CLAUDE2_1,
        UNKNOWN;

    }
}

