/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.core;

import com.assemblyai.api.core.UserAgentItem;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class UserAgent {
    private static final UserAgent defaultUserAgent = UserAgent.createDefaultUserAgent();
    private final Map<String, UserAgentItem> userAgent;

    public UserAgent(Map<String, UserAgentItem> userAgent) {
        this.userAgent = userAgent;
    }

    public UserAgent(UserAgent a, UserAgent b) {
        this.userAgent = UserAgent.merge(a.userAgent, b.userAgent);
    }

    public String toAssemblyAIUserAgentString() {
        StringBuilder sb = new StringBuilder();
        if (this.userAgent == null) {
            return sb.toString();
        }
        sb.append(" AssemblyAI/1.0 (");
        sb.append(this.userAgent.entrySet().stream().map(entry -> String.format("%s=%s/%s", entry.getKey(), ((UserAgentItem)entry.getValue()).getName(), ((UserAgentItem)entry.getValue()).getVersion())).collect(Collectors.joining(" ")));
        sb.append(")");
        return sb.toString();
    }

    public static UserAgent getDefault() {
        return defaultUserAgent;
    }

    private static UserAgent createDefaultUserAgent() {
        HashMap<String, UserAgentItem> defaultUserAgent = new HashMap<String, UserAgentItem>();
        defaultUserAgent.put("sdk", new UserAgentItem("Java", "1.1.3"));
        defaultUserAgent.put("runtime_env", new UserAgentItem(System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
        return new UserAgent(defaultUserAgent);
    }

    private UserAgent merge(UserAgent other) {
        return new UserAgent(UserAgent.merge(this.userAgent, other.userAgent));
    }

    private static Map<String, UserAgentItem> merge(Map<String, UserAgentItem> a, Map<String, UserAgentItem> b) {
        HashMap<String, UserAgentItem> newUserAgent = new HashMap<String, UserAgentItem>();
        newUserAgent.putAll(a);
        newUserAgent.putAll(b);
        for (Map.Entry<String, UserAgentItem> entry : b.entrySet()) {
            if (entry.getValue() != null) continue;
            newUserAgent.remove(entry.getKey());
        }
        return newUserAgent;
    }
}

