/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW9L;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzEq = new ArrayList();
    private final Map<String, DataColumn> zzXVT = new HashMap<String, DataColumn>();
    private DataTable zzir;

    DataColumnCollection(DataTable table) {
        this.zzir = table;
    }

    public void add(DataColumn column) {
        if (zzW9L.zzYLZ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZUL(column.getColumnName());
        if (this.zzXVT.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzXf7(this.zzir);
        column.setOrdinal(this.zzEq.size());
        this.zzEq.add(column);
        this.zzXVT.put(string, column);
        this.zzir.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzir);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzir);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzW9L.zzYLZ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZUL(columnName);
        DataColumn dataColumn = this.zzXVT.get(string);
        if (dataColumn != null) {
            int n = this.zzEq.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzEq.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzEq.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzEq.remove(n);
            this.zzXVT.remove(DataColumnCollection.zzZUL(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzir.getRows()) {
                dataRow.remove(n);
            }
            this.zzir.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzEq.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzEq.iterator();
    }

    public void clear() {
        this.zzXVT.clear();
        this.zzEq.clear();
    }

    final DataColumn[] zzXIO() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzEq);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzmP(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzEq.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzEq.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZUL(string);
            String string3 = DataColumnCollection.zzZUL(dataColumn.getColumnName());
            this.zzXVT.remove(string3);
            this.zzXVT.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZUL(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

