/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz4p;
import com.aspose.words.internal.zzMj;
import com.aspose.words.internal.zzW9L;
import com.aspose.words.internal.zzWXS;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.internal.zzYJu;
import com.aspose.words.zzYrt;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzVRX;
    private zzYrt zzXSU;

    Watermark(Document doc, zzYrt watermarkProvider) {
        this.zzVRX = doc;
        this.zzXSU = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzCb(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzmP(text, textWatermarkOptions, this.zzVRX);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzXg0.zzXa((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzVRX, 75);
        shape.getImageData().setImage(image);
        this.zzmP(shape, options, this.zzVRX);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzXg0.zzXa((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzVRX, 75);
        shape.getImageData().setImage(imagePath);
        this.zzmP(shape, options, this.zzVRX);
    }

    public final int getType() {
        Shape shape = this.zzXSU.get();
        if (shape == null) {
            return 2;
        }
        shape.zzW1D();
        if (shape.zzY9S()) {
            return 0;
        }
        if (shape.zz76()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzXSU.add(shape);
    }

    public final void remove() {
        this.zzXSU.remove();
    }

    private static void zzCb(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzMj.zzXoq(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzXg0.zzmP(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzmP(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzXa(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zz6t(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzXa(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzAa() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWOb()) / d2) > (double)(f = pageSetup.zzYjK())) {
            d = (double)f / d3;
        }
        shape.zzXid(zzYJu.zzVT3(d2 * d, 2, 1));
        shape.zzWBp(zzYJu.zzVT3(d3 * d, 2, 1));
    }

    private Shape zzmP(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzmP(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zz6t(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzmP(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZoP() ? 1.0f : textWatermarkOptions.getFontSize();
        zzWXS zzWXS2 = document.zzVYo().zzVT3(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzWXS2.zzE7(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZoP()) {
            l = Watermark.zzmP(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXid(zzYJu.zzVT3(Float.intBitsToFloat(n), 2, 1));
        shape.zzWBp(zzYJu.zzVT3(zz4p.zzVV8(l), 2, 1));
    }

    private static long zzmP(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWOb();
        float f2 = pageSetup.zzYjK();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zz4p.zzVV8(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zz4p.zz4u(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zz4p.zzVV8(l) >= Float.intBitsToFloat(n)) {
            return zz4p.zz4u(f2 / f3, f2);
        }
        float f6 = f;
        return zz4p.zz4u(f6, f6 * f3);
    }

    private static void zz6t(Shape shape, String string) {
        shape.setName(zzW9L.zzXa("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

