/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzW9L;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.zzWsn;
import com.aspose.words.zzXwO;
import com.aspose.words.zzZl7;

public final class Section
extends CompositeNode<Node>
implements zzWsn {
    private zzXwO zzao;
    private PageSetup zzW6G;
    private HeaderFooterCollection zzY9q;

    public Section(DocumentBase doc) {
        this(doc, new zzXwO());
    }

    Section(DocumentBase doc, zzXwO sectPr) {
        super(doc);
        this.zzao = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzY9q == null) {
            this.zzY9q = new HeaderFooterCollection(this);
        }
        return this.zzY9q;
    }

    public final PageSetup getPageSetup() {
        if (this.zzW6G == null) {
            Section section = this;
            this.zzW6G = new PageSetup(section, section.getDocument().zzWYE(), this.getDocument().getStyles(), new zzmP(this));
        }
        return this.zzW6G;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYcs();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYT5(!value);
    }

    final zzXwO zzZ8h() {
        return this.zzao;
    }

    final void zzXa(zzXwO zzXwO2) {
        this.zzao = zzXwO2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzmP(boolean bl, zzZl7 zzZl72) {
        zzXwO zzXwO2;
        Section section = (Section)super.zzmP(bl, zzZl72);
        zzXwO zzXwO3 = this.zzao;
        section.zzao = zzXwO2 = (zzXwO)zzXwO3.zzX6h();
        section.zzW6G = null;
        section.zzY9q = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzXf7(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzXf7(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYUN(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzXcX(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYUN(n) == null;
            }
        }
        return false;
    }

    final void zzVT3(Shape shape, boolean bl) throws Exception {
        this.zzmP(shape, 4, bl);
        this.zzmP(shape, 0, bl);
        this.zzmP(shape, 1, bl);
    }

    private void zzmP(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzYlU());
        shape2.setName(zzW9L.zzXa("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzZzZ() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWX0()) {
                if (!shape.zzW1D()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzXf7(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzXa(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzao.zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWYE().zzWr5.zzZ31(key);
        }
        return zzXwO.zzYEj(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzao.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWYE().zzWr5.zzZqs(key, value);
            return;
        }
        this.zzao.zzZqs(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzao.clear();
    }

    final boolean zzW7D() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzW42() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzao.getSectionStart());
        return zzW9L.zzXa("{0} {1}", objectArray);
    }

    static final class zzmP
    implements zzWsn {
        private Section zzWZV;

        zzmP(Section section) {
            this.zzWZV = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzXea().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzXea().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzXea().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzWsn zzXea() {
            Document document = zzXg0.zzmP((Object)this.zzWZV.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWZV;
        }
    }
}

