/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzVWI;
import com.aspose.words.internal.zzYdl;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzZ00;
    private boolean zzU5;
    boolean zzZxJ = true;
    private boolean zzGC = true;
    private boolean zzXdp = false;
    private boolean zzZsm;
    private boolean zzYBg = true;
    private boolean zzZaK;
    private String zzXbl;
    private boolean zzGG;
    private boolean zzZC7 = false;
    private int zzYsR = 1;
    private int zzdZ = 1;
    private int zzYdd = 0;
    private String zzWR0 = "";
    private boolean zzZpm = true;
    private boolean zz6v = true;
    private boolean zzjr;
    private boolean zzZ2q;
    private int zzWwp = 0;
    private boolean zzZOj = true;
    private boolean zzWFN = false;

    protected SaveOptions() {
    }

    final boolean zzWLf() {
        return this.zzZsm;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzXpj() {
        return false;
    }

    boolean zzYJq() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYBg;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYBg = value;
    }

    public String getTempFolder() {
        return this.zzXbl;
    }

    public void setTempFolder(String value) {
        this.zzXbl = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZaK;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZaK = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzGG;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzGG = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZC7;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZC7 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYsR;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYsR = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYdd;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYdd = value;
    }

    public int getImlRenderingMode() {
        return this.zzdZ;
    }

    public void setImlRenderingMode(int value) {
        this.zzdZ = value;
    }

    public String getDefaultTemplate() {
        return this.zzWR0;
    }

    public void setDefaultTemplate(String value) {
        this.zzWR0 = value;
    }

    public boolean getUpdateFields() {
        return this.zzZpm;
    }

    public void setUpdateFields(boolean value) {
        this.zzZpm = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzjr;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzjr = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZ2q;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZ2q = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzWFN;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzWFN = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXdp;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXdp = value;
    }

    final boolean zzXwh() {
        return this.zz6v;
    }

    final boolean zzYzY() {
        return this.zzZOj;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWnl(zzVWI.zzZzG(zzYdl.zzW3Q(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWwp;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWwp = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZ00;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZ00 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzU5;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzU5 = value;
    }

    final boolean zzXch() {
        return this.zzGC;
    }

    final void zzWwb(boolean bl) {
        this.zzGC = false;
    }
}

