/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzW9L;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.internal.zzXwR;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXGa;
import com.aspose.words.zzXKR;
import com.aspose.words.zzXsx;
import com.aspose.words.zzZXR;
import com.aspose.words.zzZl7;
import com.aspose.words.zzla;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzYb7;
    private Node zzXph;
    private Node zzXCf;
    private int zzWzi;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzVT3(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYb7 == null) {
            return null;
        }
        if (this.zzYb7.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzYb7;
    }

    final CompositeNode zzYV0() {
        if (zzXsx.zzWZ(this.getParentNode())) {
            return this.getParentNode().zzYV0();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZkl() {
        if (zzXsx.zzWZ(this.getParentNode()) || zzXsx.zzWdr(this.getParentNode())) {
            return this.getParentNode().zzZkl();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzYb7 != null) {
            return this.zzYb7.getDocument();
        }
        return null;
    }

    final Document zzVWQ() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzYFw() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzWaH();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXCf;
    }

    final Node zzWJG() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzXsx.zzYIX((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzY2K() {
        Node node = zzXsx.zzZqs(this.getPreviousSibling(), false);
        if (node == null && zzXsx.zzWZ(this.getParentNode())) {
            node = this.getParentNode().zzY2K();
        }
        return node;
    }

    final Node zzWIl() {
        Node node = zzXsx.zzWsc(this.getNextSibling(), false);
        if (node == null && zzXsx.zzWZ(this.getParentNode())) {
            node = this.getParentNode().zzWIl();
        }
        return node;
    }

    final CompositeNode zz0C() {
        Node node = this;
        while ((node = node.zzY2K()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWcB() {
        Node node = this;
        while ((node = node.zzWIl()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzXph;
    }

    final Node zzZ9F() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzXsx.zzYIX((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzAR() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZGC() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXFK() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXsx.zzXqj(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWGo() {
        return this.zzXph;
    }

    final void zzZlw(Node node) {
        this.zzXph = node;
    }

    final Node zzZYu() {
        return this.zzXCf;
    }

    final void zzWLS(Node node) {
        this.zzXCf = node;
    }

    final Node zzXP8() {
        Node node = this;
        if (node.zzXph != null) {
            node = this;
            return node.zzXph;
        }
        return this.getParentNode();
    }

    final int zzXFH() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXsx.zzX5r(this);
        boolean bl2 = zzXsx.zzXee(this);
        boolean bl3 = zzXsx.zzYfo(this);
        boolean bl4 = zzXsx.zzXim(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXFH() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXFH() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzmP(isCloneChildren, new zzmP(this));
    }

    Node zzmP(boolean bl, zzZl7 zzZl72) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYb7 != null) {
            node.zzYb7 = this.getDocument().zzXBW();
        }
        node.zzXph = null;
        node.zzXCf = null;
        if (zzZl72 != null) {
            zzZl72.zzXf7(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZCn(StringBuilder stringBuilder) {
        zzXg0.zzXa(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzZXR zzXTY() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzZXR zzZXR2 = zzXg0.zzmP((Object)compositeNode, zzZXR.class);
            if (zzZXR2 == null) continue;
            return zzZXR2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWN7(Node node) {
        this.zzYb7 = node != null ? node : this.getDocument().zzXBW();
    }

    final void zzVT3(DocumentBase documentBase) {
        this.zzYb7 = documentBase != null ? documentBase.zzXBW() : null;
    }

    final boolean zzYC8(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzk7() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzX2i(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWFG(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzXVi(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZCn(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZnw(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zz1h(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zz8d(Node node, Node node2) {
        this.getParentNode().zzXa(node, node2, this);
    }

    final Node zzYES(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzWbc(Node node, Node node2) {
        this.getParentNode().zzmP(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzXGa zzXGa2 = zzXsx.zzRy(saveFormat);
        return zzXGa2.zzYfA(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzXGa zzXGa2 = zzXsx.zzXa(saveOptions);
        return zzXGa2.zzYfA(this);
    }

    final Node zzZRJ(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXsx.zzXso(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzla zzXWP() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzla.zzYnA(node);
        }
        return zzla.zzXVy(this.getParentNode());
    }

    final zzla zzWgr() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzla.zzXVy(node);
        }
        return zzla.zzYnA(this.getParentNode());
    }

    final boolean zzYeF(Node node) {
        return Node.zzYnA(this, node);
    }

    final boolean zzVRd() {
        return this.getAncestor(1) == null;
    }

    static Node zzXVy(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXwR<Node> zzXwR2 = Node.zzVQ6(node);
        zzXwR<Node> zzXwR3 = Node.zzVQ6(node2);
        return Node.zzmP(zzXwR2, zzXwR3);
    }

    static boolean zzYnA(Node node, Node node2) {
        zzXwR<Node> zzXwR2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXwR<Node> zzXwR3 = Node.zzVQ6(node);
        Node node3 = Node.zzmP(zzXwR3, zzXwR2 = Node.zzVQ6(node2));
        if (node3 == null) {
            return false;
        }
        zzXwR<Node> zzXwR4 = zzXwR3;
        if (zzXwR4.size() == 0 || (zzXwR4 = zzXwR2).size() == 0) {
            zzXwR4 = zzXwR2;
            boolean bl = zzXwR4.size() > 0;
            return bl;
        }
        Object e = zzXwR3.peek();
        Object e2 = zzXwR2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXwR<Node> zzVQ6(Node node) {
        zzXwR<Node> zzXwR2 = new zzXwR<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXwR2.push(node2);
        }
        return zzXwR2;
    }

    private static Node zzmP(zzXwR<Node> zzXwR2, zzXwR<Node> zzXwR3) {
        Node node = null;
        while (zzXwR2.peek() == zzXwR3.peek()) {
            node = (Node)zzXwR2.pop();
            zzXwR3.pop();
            zzXwR<Node> zzXwR4 = zzXwR2;
            if (zzXwR4.size() != 0 && (zzXwR4 = zzXwR3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzWzi;
    }

    public void setCustomNodeId(int value) {
        this.zzWzi = value;
    }

    private String zzW5n() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzXg0.zzmP(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzW9L.zzZbb(stringBuilder.toString());
    }

    public String toString() {
        return zzW9L.zzZbb(zzW9L.zzXa("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzW5n()));
    }

    public void dd() {
    }

    final Node zzE7(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXFo(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWBC(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzXFo(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzXFo(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzmP
    implements zzZl7 {
        private Node zzQd;
        private HashMap<Integer, Integer> zzZmS;

        zzmP(Node node) {
            this.zzQd = node;
        }

        @Override
        public final void zzXf7(Node node, Node node2) {
            if (node == this.zzQd) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzXKR zzXKR2 = (zzXKR)((Object)node2);
            if (this.zzZmS == null) {
                this.zzZmS = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzXg0.zzmP(this.zzZmS, Integer.valueOf(zzXKR2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZ3Z();
                zzXg0.zzXa(this.zzZmS, Integer.valueOf(zzXKR2.getIdInternal()), Integer.valueOf(n));
            }
            zzXKR2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzXg0.zzmP(this.zzZmS, Integer.valueOf(zzXKR2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzXKR2.setParentIdInternal(n2);
            }
        }
    }
}

